/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.client;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import pacManReloaded.client.ClientGUI;
import pacManReloaded.client.ClientThread;
import pacManReloaded.common.Command;
import pacManReloaded.common.CommandFactory;
import pacManReloaded.common.messages.ChatMessage;
import pacManReloaded.common.messages.ChatWithAddress;
import pacManReloaded.common.messages.GameFinishedMessage;
import pacManReloaded.common.messages.IMessage;
import pacManReloaded.common.messages.MapMessage;
import pacManReloaded.common.model.Ball;
import pacManReloaded.common.model.Direction;
import pacManReloaded.common.model.Gate;
import pacManReloaded.common.model.Ghost;
import pacManReloaded.common.model.GhostColor;
import pacManReloaded.common.model.Map;
import pacManReloaded.common.model.PacMan;
import pacManReloaded.common.model.PowerBall;
import pacManReloaded.common.model.Wall;
import pacManReloaded.server.GameState;
import pacManReloaded.server.Player;

public class Client {
    private Socket socket;
    private final int pingInterval = 5000;
    String serverAddress;
    int serverPort;
    private boolean isConnected;
    private ClientGUI clientGUI;
    private ClientThread clientThread;
    private String tempNickname;
    private Map map;
    private GameState gameState;
    private HashMap<String, Player> actors;

    public Client(String nickname, String ipAddress, int port) {
        this.tempNickname = nickname == null || nickname.trim().length() == 0 ? System.getProperty("user.name") : nickname;
        this.serverAddress = ipAddress;
        this.serverPort = port;
        this.clientGUI = ClientGUI.initGUI();
        this.clientGUI.setClient(this);
        this.actors = new HashMap();
    }

    public void disconnectFromServer() {
        System.out.println("Disconnecting from server");
        if (this.clientThread != null) {
            this.clientThread.close();
            System.out.println("Thread stopped");
            this.isConnected = false;
        }
    }

    public void sendChatMessage(String message) {
        System.out.println("Sending chat: " + message);
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.clientThread.getMyName());
        params.add(message);
        IMessage gameMessage = CommandFactory.createMessage(Command.MESSAGE, params);
        this.clientThread.send(gameMessage);
    }

    public boolean connectToServer() {
        if (this.clientThread != null) {
            this.isConnected = true;
            return true;
        }
        System.out.println("Establishing connection. Please wait ...");
        try {
            this.socket = new Socket(this.serverAddress, this.serverPort);
            System.out.println("Connected: " + this.socket);
            this.start(this.socket);
            this.isConnected = true;
            return true;
        }
        catch (IOException e) {
            this.isConnected = false;
            System.out.println("Unexpected exception: " + e.getMessage());
            return false;
        }
    }

    private void start(Socket socket) throws IOException {
        this.clientThread = new ClientThread(this, socket, this.tempNickname);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Client.this.checkPingPong();
                Client.this.activeLobbiesRequest();
                Client.this.activeClientsRequest();
            }
        }, 5000L, 5000L);
    }

    private void activeClientsRequest() {
        if (this.clientThread == null) {
            return;
        }
        long now = System.currentTimeMillis();
        System.out.println("active clients request... " + this.toReadableTime(now));
        IMessage requestMsg = CommandFactory.createMessage(Command.GET_CLIENT_INFO, null);
        this.clientThread.send(requestMsg);
    }

    private void activeLobbiesRequest() {
        if (this.clientThread == null) {
            return;
        }
        long now = System.currentTimeMillis();
        System.out.println("active lobbies request... " + this.toReadableTime(now));
        IMessage requestMsg = CommandFactory.createMessage(Command.GET_LOBBY_INFO, null);
        this.clientThread.send(requestMsg);
    }

    void stopThread() {
        if (this.clientThread != null) {
            this.clientThread.interrupt();
            this.clientThread = null;
            this.clientGUI.disconnect();
        }
    }

    public void changeName(String name) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(name);
        IMessage myNameMsg = CommandFactory.createMessage(Command.MY_NICKNAME, params);
        this.clientThread.send(myNameMsg);
    }

    private synchronized void checkPingPong() {
        if (this.clientThread == null) {
            return;
        }
        long now = System.currentTimeMillis();
        System.out.println("Ping check..." + this.toReadableTime(now));
        IMessage pingMsg = CommandFactory.createMessage(Command.PING, null);
        if (now - this.clientThread.getLastContact() > 20000L) {
            this.clientThread.close();
        } else if (now - this.clientThread.getLastContact() > 5000L) {
            this.clientThread.send(pingMsg);
            System.out.println("Ping sent to server at:" + this.toReadableTime(now));
        }
    }

    void sendBeginGame() {
        System.out.println("Sending begin game message");
        IMessage beginGame = CommandFactory.createMessage(Command.BEGIN_GAME, null);
        this.clientThread.send(beginGame);
    }

    private void sendChatMessageToReceiver(String receiver, String msg) {
        System.out.println("Sending chat message: " + msg);
        ArrayList<String> params = new ArrayList<String>();
        params.add(receiver);
        params.add(msg);
        IMessage gameMessage = CommandFactory.createMessage(Command.SEND_TO_ADDRESS, params);
        this.clientThread.send(gameMessage);
    }

    public void tryToChangeDirection(String direction) {
        System.out.println("Sending directionChange: " + direction);
        ArrayList<String> params = new ArrayList<String>();
        params.add(direction);
        IMessage gameMessage = CommandFactory.createMessage(Command.CHANGE_DIRECTION, params);
        this.clientThread.send(gameMessage);
    }

    void sendJoinLobbyMessage(String lobbyName) {
        lobbyName = lobbyName.replace("|", "_");
        System.out.println("Sending join lobby message: " + lobbyName);
        this.clientThread.setMyLobby(lobbyName);
        ArrayList<String> params = new ArrayList<String>();
        params.add(lobbyName);
        IMessage gameMessage = CommandFactory.createMessage(Command.JOIN_LOBBY, params);
        this.clientThread.send(gameMessage);
    }

    public void sendGetManual() {
        System.out.println("Sending GET_MANUAL");
        IMessage getManual = CommandFactory.createMessage(Command.GET_MANUAL, null);
        this.clientThread.send(getManual);
    }

    public void sendGetHighScore() {
        System.out.println("Sending GET_HIGHSCORE");
        IMessage getHighScore = CommandFactory.createMessage(Command.GET_HIGHSCORE, null);
        this.clientThread.send(getHighScore);
    }

    private String toReadableTime(long timeInms) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date resultDate = new Date(timeInms);
        return sdf.format(resultDate);
    }

    void handleSendRequest(String input) {
        if (this.isClientInLobby()) {
            String receiver = this.clientThread.getMyLobby();
            this.sendChatMessageToReceiver(receiver, input);
        } else {
            this.sendChatMessageToReceiver("NotInLobby", input);
        }
    }

    void handleWhisperRequest(String input) {
        String[] splitted = input.split(" ");
        String receiver = splitted[0];
        Object msg = splitted[1];
        if (splitted.length >= 2) {
            for (int i = 2; i < splitted.length; ++i) {
                msg = (String)msg + " " + splitted[i];
            }
            this.sendChatMessageToReceiver(receiver, (String)msg);
        }
    }

    public synchronized void handleMap(MapMessage mapMessage) throws Exception {
        String[] spawn;
        String[] walls;
        this.map = new Map();
        String input = mapMessage.getParamValueSize();
        String[] parts = input.split(",");
        this.map.xSize = Integer.parseInt(parts[0]);
        this.map.ySize = Integer.parseInt(parts[1]);
        this.map.tSize = Integer.parseInt(parts[2].replace(";", ""));
        input = mapMessage.getParamValueWalls();
        for (String w : walls = input.split("!")) {
            this.map.Walls.add(this.createWall(w));
        }
        input = mapMessage.getParamValueSpawn();
        for (String s : spawn = input.split("!")) {
            this.map.Spawn.add(this.createWall(s));
        }
        input = mapMessage.getParamValuePowerBalls();
        this.map.PowerBalls.addAll(this.createPowerBalls(input));
        input = mapMessage.getParamValueBalls();
        this.map.Balls.addAll(this.createBalls(input));
        input = mapMessage.getParamValueGate();
        this.map.gate = this.createGate(input);
        this.clientGUI.paintMap(this.map);
    }

    public void handleActorInit(String paramValue) {
        String[] playerType;
        for (String p : playerType = paramValue.split(";")) {
            Point2D.Float point2D;
            String[] parts = p.split(",");
            if (parts[1].equals("PacMan")) {
                point2D = new Point2D.Float(Float.parseFloat(parts[2]), Float.parseFloat(parts[3]));
                this.actors.put(parts[0], new PacMan(point2D, null, point2D));
                continue;
            }
            if (!parts[1].equals("Ghost")) continue;
            point2D = new Point2D.Float(Float.parseFloat(parts[3]), Float.parseFloat(parts[4]));
            this.actors.put(parts[0], new Ghost(point2D, null, point2D));
            ((Ghost)this.actors.get((Object)parts[0])).color = GhostColor.valueOf(parts[2]);
        }
    }

    public void handleInitGameState(String paramValue) {
        String[] parts = paramValue.split(",");
        this.gameState = new GameState(Integer.parseInt(parts[2]), Integer.parseInt(parts[1]));
        this.gameState.superPower = Integer.parseInt(parts[0]);
    }

    public void handleGameState(String paramValue) {
        String[] parts = paramValue.split(",");
        this.gameState.superPower = Integer.parseInt(parts[0]);
        this.gameState.scoreGhost = Integer.parseInt(parts[1]);
        this.gameState.scorePacMan = Integer.parseInt(parts[2]);
    }

    public void handleActorPos(String parm) {
        String[] playerType;
        for (String p : playerType = parm.split(";")) {
            String[] parts = p.split(",");
            Player ply = this.actors.get(parts[0]);
            ply.direction = Direction.valueOf(parts[1]);
            Point2D.Float point2D = new Point2D.Float(Float.parseFloat(parts[2]), Float.parseFloat(parts[3]));
            ply.setPosition(point2D);
        }
    }

    public synchronized void handleRemoveObject(String paramValue) {
        String[] parts = paramValue.split(",");
        Point2D.Float point = new Point2D.Float(Float.parseFloat(parts[0]), Float.parseFloat(parts[1]));
        Object o = this.map.getObject(point);
        if (o instanceof Ball) {
            this.map.removeBall((Ball)o);
        }
        if (o instanceof PowerBall) {
            this.map.removePowerBall((PowerBall)o);
        }
        this.clientGUI.paintMap(this.map);
    }

    private Gate createGate(String line) {
        int x = 0;
        int y = 0;
        Point2D.Float point = null;
        String[] coordinated = line.split(",");
        x = (int)Float.parseFloat(coordinated[0]);
        y = (int)Float.parseFloat(coordinated[1].replace(";", ""));
        point = new Point2D.Float(x, y);
        Gate gate = new Gate(point);
        return gate;
    }

    private List<Ball> createBalls(String line) {
        int x = 0;
        int y = 0;
        Point2D.Float point = null;
        ArrayList<Ball> allBalls = new ArrayList<Ball>();
        String[] points = line.split(";");
        for (int i = 0; i < points.length; ++i) {
            String[] coordinates = points[i].split(",");
            x = (int)Float.parseFloat(coordinates[0]);
            y = (int)Float.parseFloat(coordinates[1]);
            point = new Point2D.Float(x, y);
            Ball Ball2 = new Ball(point);
            allBalls.add(Ball2);
        }
        return allBalls;
    }

    private List<PowerBall> createPowerBalls(String line) {
        int x = 0;
        int y = 0;
        Point2D.Float point = null;
        ArrayList<PowerBall> allBalls = new ArrayList<PowerBall>();
        String[] points = line.split(";");
        for (int i = 0; i < points.length; ++i) {
            String[] coordinates = points[i].split(",");
            x = (int)Float.parseFloat(coordinates[0]);
            y = (int)Float.parseFloat(coordinates[1]);
            point = new Point2D.Float(x, y);
            PowerBall powerBall = new PowerBall(point);
            allBalls.add(powerBall);
        }
        return allBalls;
    }

    private Wall createWall(String line) {
        int x = 0;
        int y = 0;
        Point2D.Float point = null;
        ArrayList<Point2D.Float> Points = new ArrayList<Point2D.Float>();
        String[] pointcoordinates = line.split(";");
        ArrayList<String[]> coordinates = new ArrayList<String[]>();
        for (int i = 0; i < pointcoordinates.length; ++i) {
            coordinates.add(pointcoordinates[i].split(","));
        }
        for (String[] strings : coordinates) {
            x = (int)Float.parseFloat(strings[0]);
            y = (int)Float.parseFloat(strings[1]);
            point = new Point2D.Float(x, y);
            Points.add(point);
        }
        Wall wall = new Wall(Points);
        return wall;
    }

    public void forwardJoinLobbyResponse(boolean b) {
        this.clientGUI.handleLobbyResponse(b);
    }

    void forwardChatToMeMessage(ChatWithAddress chatToMeMessage) {
        this.clientGUI.handleChatToMeMessage(chatToMeMessage);
    }

    void forwardChat(ChatMessage chatMessage) {
        this.clientGUI.handleChat(chatMessage);
    }

    public void forwardBeginFailed() {
        this.clientGUI.handleBeginFailed();
    }

    void forwardName(String myName) {
        this.clientGUI.initName(myName);
    }

    void forwardLobbyInfo(String serverInfo) {
        this.clientGUI.setLobbyInfo(serverInfo);
    }

    void forwardClientInfo(String serverInfo) {
        this.clientGUI.setClientInfo(serverInfo);
    }

    public void forwardHighScore(String paramValue) {
        this.clientGUI.handleHighScore(paramValue);
    }

    public void forwardManual(String paramValue) {
        this.clientGUI.handleManual(paramValue);
    }

    public void handleGameFinish(GameFinishedMessage gameFinishedMessage) {
        this.clientGUI.setGameFinish(gameFinishedMessage.getAnswer());
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    boolean isClientInLobby() {
        return this.clientThread.getMyLobby() != null;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public String getLobby() {
        return this.clientThread.getMyLobby();
    }

    public HashMap<String, Player> getActors() {
        return this.actors;
    }

    public GameState getGameState() {
        return this.gameState;
    }
}

