/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.client;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;
import pacManReloaded.client.Client;
import pacManReloaded.client.InformationGUI;
import pacManReloaded.common.Lock;
import pacManReloaded.common.messages.ChatMessage;
import pacManReloaded.common.messages.ChatWithAddress;
import pacManReloaded.common.model.Ball;
import pacManReloaded.common.model.Gate;
import pacManReloaded.common.model.Ghost;
import pacManReloaded.common.model.Map;
import pacManReloaded.common.model.PacMan;
import pacManReloaded.common.model.PowerBall;
import pacManReloaded.common.model.Sound;
import pacManReloaded.common.model.Wall;
import pacManReloaded.server.GameState;
import pacManReloaded.server.Player;

public class ClientGUI
extends JFrame {
    private JPanel rootPanel;
    private JTextArea lobbyTextArea;
    private JTextArea clientsTextArea;
    private JButton btnSend;
    private JButton btnBroadcast;
    private JButton btnWhisper;
    private JButton btnChangeName;
    private JTextArea chatTextArea;
    private JTextField chatInputTextField;
    private JTextArea playerInfoTextArea;
    private JTextArea gameMasterTextArea;
    private JButton btnConnect;
    private JButton btnDisconnect;
    private JButton btnJoin;
    private JButton btnBegin;
    private JButton btnHighscore;
    private JButton btnManual;
    private Thread glThread;
    private Lock lock = new Lock();
    private Sound sound = new Sound();
    final int FRAMES_PER_SECOND = 20;
    private volatile boolean isRunning = false;
    private TrueTypeFont font;
    private TrueTypeFont font2;
    private boolean antiAlias = true;
    private Client client;
    private String myName;
    private Map map;
    private Texture tex;
    private float x;
    private float y;
    HashMap<String, Texture> textures;
    private final int tSize = 20;
    private int WIDTH;
    private int HEIGHT;
    private boolean finish;
    private String finishResult;
    private static boolean closeRequested = false;
    private static final AtomicReference<Dimension> newCanvasSize = new AtomicReference();

    private ClientGUI() {
        Font f = new Font("Arial", 0, 13);
        java.awt.Color yellow = new java.awt.Color(253, 240, 0);
        java.awt.Color blue = new java.awt.Color(63, 72, 203);
        this.setBounds(100, 100, 1160, 940);
        this.setDefaultCloseOperation(3);
        UIManager.put("TabbedPane.contentAreaColor", java.awt.Color.BLACK);
        UIManager.put("TabbedPane.selected", java.awt.Color.BLACK);
        Insets insets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        insets.top = -1;
        UIManager.put("TabbedPane.contentBorderInsets", insets);
        insets.bottom = -1;
        UIManager.put("TabbedPane.contentBorderInsets", insets);
        insets.left = -1;
        UIManager.put("TabbedPane.contentBorderInsets", insets);
        insets.right = -1;
        UIManager.put("TabbedPane.contentBorderInsets", insets);
        this.rootPanel = new JPanel();
        this.rootPanel.setBackground(java.awt.Color.BLACK);
        this.rootPanel.setBorder(BorderFactory.createLineBorder(blue));
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rootPanel, -1, 1160, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rootPanel, GroupLayout.Alignment.TRAILING, -1, 880, Short.MAX_VALUE));
        JPanel controlPanel = new JPanel();
        controlPanel.setBackground(java.awt.Color.BLACK);
        JPanel playingFieldPanel = new JPanel();
        playingFieldPanel.setBackground(java.awt.Color.BLACK);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ClientGUI.this.setVisible(false);
                ClientGUI.this.dispose();
            }
        });
        final Canvas canvas = new Canvas(){

            @Override
            public void addNotify() {
                super.addNotify();
                ClientGUI.this.startGL();
            }

            @Override
            public void removeNotify() {
                ClientGUI.this.stopGL();
                super.removeNotify();
            }
        };
        canvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                newCanvasSize.set(canvas.getSize());
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                canvas.requestFocusInWindow();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                closeRequested = true;
            }
        });
        canvas.setPreferredSize(new Dimension(660, 880));
        canvas.setIgnoreRepaint(true);
        try {
            Display.setParent(canvas);
            Display.setVSyncEnabled(true);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        playingFieldPanel.add(canvas);
        JPanel infoPanel = new JPanel();
        infoPanel.setBackground(java.awt.Color.BLACK);
        GroupLayout gl_rootPanel = new GroupLayout(this.rootPanel);
        gl_rootPanel.setHorizontalGroup(gl_rootPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_rootPanel.createSequentialGroup().addComponent(controlPanel, -1, 220, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(playingFieldPanel, -1, 660, Short.MAX_VALUE).addGap(13).addComponent(infoPanel, -2, 280, Short.MAX_VALUE)));
        gl_rootPanel.setVerticalGroup(gl_rootPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(controlPanel, GroupLayout.Alignment.TRAILING, -1, 880, Short.MAX_VALUE).addGroup(gl_rootPanel.createSequentialGroup().addComponent(playingFieldPanel, -1, 880, Short.MAX_VALUE).addContainerGap()).addComponent(infoPanel, -1, 880, Short.MAX_VALUE));
        JPanel chatPanel = new JPanel();
        chatPanel.setBackground(java.awt.Color.BLACK);
        JPanel lobby_clientPanel = new JPanel();
        lobby_clientPanel.setBackground(java.awt.Color.BLACK);
        GroupLayout gl_infoPanel = new GroupLayout(infoPanel);
        gl_infoPanel.setHorizontalGroup(gl_infoPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_infoPanel.createSequentialGroup().addGroup(gl_infoPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lobby_clientPanel, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(chatPanel, GroupLayout.Alignment.LEADING, -2, 278, Short.MAX_VALUE)).addGap(2)));
        gl_infoPanel.setVerticalGroup(gl_infoPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_infoPanel.createSequentialGroup().addComponent(chatPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lobby_clientPanel, -1, 347, Short.MAX_VALUE)));
        JScrollPane scrollPane_2 = new JScrollPane();
        scrollPane_2.setBorder(BorderFactory.createLineBorder(blue));
        scrollPane_2.setBackground(java.awt.Color.BLACK);
        GroupLayout gl_lobby_clientPanel = new GroupLayout(lobby_clientPanel);
        gl_lobby_clientPanel.setHorizontalGroup(gl_lobby_clientPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_lobby_clientPanel.createSequentialGroup().addComponent(scrollPane_2, -1, 284, Short.MAX_VALUE).addContainerGap()));
        gl_lobby_clientPanel.setVerticalGroup(gl_lobby_clientPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_lobby_clientPanel.createSequentialGroup().addComponent(scrollPane_2, -1, 332, Short.MAX_VALUE).addContainerGap()));
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.setForeground(yellow);
        tabbedPane.setBackground(java.awt.Color.DARK_GRAY);
        this.getContentPane().setBackground(java.awt.Color.BLACK);
        tabbedPane.setBorder(BorderFactory.createLineBorder(blue));
        scrollPane_2.setViewportView(tabbedPane);
        this.lobbyTextArea = new JTextArea();
        this.lobbyTextArea.setBorder(BorderFactory.createLineBorder(blue));
        this.lobbyTextArea.setDisabledTextColor(yellow);
        this.lobbyTextArea.setBackground(java.awt.Color.BLACK);
        this.lobbyTextArea.setEnabled(false);
        this.lobbyTextArea.setEditable(false);
        this.lobbyTextArea.setFont(f);
        tabbedPane.addTab("Lobby", null, this.lobbyTextArea, null);
        this.clientsTextArea = new JTextArea();
        this.clientsTextArea.setBorder(BorderFactory.createLineBorder(blue));
        this.clientsTextArea.setBackground(java.awt.Color.BLACK);
        this.clientsTextArea.setDisabledTextColor(yellow);
        this.clientsTextArea.setEnabled(false);
        this.clientsTextArea.setEditable(false);
        this.clientsTextArea.setFont(f);
        tabbedPane.addTab("Clients", null, this.clientsTextArea, null);
        lobby_clientPanel.setLayout(gl_lobby_clientPanel);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBorder(BorderFactory.createLineBorder(blue));
        scrollPane_1.setBackground(java.awt.Color.BLACK);
        JPanel chat_functionPanel = new JPanel();
        chat_functionPanel.setBackground(java.awt.Color.BLACK);
        GroupLayout gl_chatPanel = new GroupLayout(chatPanel);
        gl_chatPanel.setHorizontalGroup(gl_chatPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_chatPanel.createSequentialGroup().addGroup(gl_chatPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(chat_functionPanel, GroupLayout.Alignment.LEADING, -2, 263, Short.MAX_VALUE).addComponent(scrollPane_1, -1, 263, Short.MAX_VALUE)).addGap(15)));
        gl_chatPanel.setVerticalGroup(gl_chatPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_chatPanel.createSequentialGroup().addContainerGap().addComponent(scrollPane_1, -1, 329, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(chat_functionPanel, -2, 110, Short.MAX_VALUE).addGap(4)));
        this.chatInputTextField = new JTextField();
        this.chatInputTextField.setBackground(java.awt.Color.black);
        this.chatInputTextField.setForeground(yellow);
        this.chatInputTextField.setBorder(BorderFactory.createLineBorder(blue));
        this.chatInputTextField.setColumns(10);
        this.btnSend = new JButton("Send");
        this.btnSend.setBackground(java.awt.Color.BLACK);
        this.btnSend.setForeground(yellow);
        this.btnSend.setBorder(BorderFactory.createLineBorder(blue));
        this.btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientGUI.this.sendButtonGetClicked();
            }
        });
        this.btnWhisper = new JButton("Whisper");
        this.btnWhisper.setBackground(java.awt.Color.BLACK);
        this.btnWhisper.setForeground(yellow);
        this.btnWhisper.setBorder(BorderFactory.createLineBorder(blue));
        this.btnWhisper.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientGUI.this.whisperButtonGetClicked();
            }
        });
        this.btnBroadcast = new JButton("Broadcast");
        this.btnBroadcast.setBackground(java.awt.Color.BLACK);
        this.btnBroadcast.setForeground(yellow);
        this.btnBroadcast.setBorder(BorderFactory.createLineBorder(blue));
        this.btnBroadcast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientGUI.this.broadcastButtonGetClicked();
            }
        });
        GroupLayout gl_chat_functionPanel = new GroupLayout(chat_functionPanel);
        gl_chat_functionPanel.setHorizontalGroup(gl_chat_functionPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_chat_functionPanel.createSequentialGroup().addGroup(gl_chat_functionPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_chat_functionPanel.createSequentialGroup().addComponent(this.chatInputTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSend, -1, 108, Short.MAX_VALUE)).addGroup(gl_chat_functionPanel.createSequentialGroup().addComponent(this.btnWhisper, -1, 144, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBroadcast, -1, 110, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGap(0)));
        gl_chat_functionPanel.setVerticalGroup(gl_chat_functionPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_chat_functionPanel.createSequentialGroup().addGap(6).addGroup(gl_chat_functionPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSend, -1, 37, Short.MAX_VALUE).addComponent(this.chatInputTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gl_chat_functionPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnWhisper, -1, 36, Short.MAX_VALUE).addComponent(this.btnBroadcast, -1, 36, Short.MAX_VALUE)).addGap(22)));
        chat_functionPanel.setLayout(gl_chat_functionPanel);
        JTabbedPane tabbedPane_2 = new JTabbedPane(1);
        tabbedPane_2.setForeground(yellow);
        tabbedPane_2.setBackground(java.awt.Color.DARK_GRAY);
        scrollPane_1.setViewportView(tabbedPane_2);
        this.chatTextArea = new JTextArea();
        this.chatTextArea.setBorder(BorderFactory.createLineBorder(blue));
        this.chatTextArea.setDisabledTextColor(yellow);
        this.chatTextArea.setBackground(java.awt.Color.BLACK);
        this.chatTextArea.setEnabled(false);
        this.chatTextArea.setEditable(false);
        this.chatTextArea.setFont(f);
        this.chatTextArea.setDisabledTextColor(yellow);
        tabbedPane_2.addTab("Chat", null, this.chatTextArea, null);
        chatPanel.setLayout(gl_chatPanel);
        infoPanel.setLayout(gl_infoPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(java.awt.Color.BLACK);
        JPanel notePanel = new JPanel();
        notePanel.setBackground(java.awt.Color.BLACK);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createLineBorder(blue));
        scrollPane.setBackground(java.awt.Color.BLACK);
        GroupLayout gl_notePanel = new GroupLayout(notePanel);
        gl_notePanel.setHorizontalGroup(gl_notePanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, gl_notePanel.createSequentialGroup().addContainerGap().addComponent(scrollPane, -1, 181, Short.MAX_VALUE)));
        gl_notePanel.setVerticalGroup(gl_notePanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_notePanel.createSequentialGroup().addContainerGap().addComponent(scrollPane, -1, 377, Short.MAX_VALUE)));
        JTabbedPane tabbedPane_1 = new JTabbedPane(1);
        tabbedPane_1.setForeground(yellow);
        tabbedPane_1.setBackground(java.awt.Color.DARK_GRAY);
        scrollPane.setViewportView(tabbedPane_1);
        this.gameMasterTextArea = new JTextArea();
        this.gameMasterTextArea.setEnabled(false);
        this.gameMasterTextArea.setEditable(false);
        this.gameMasterTextArea.setBorder(BorderFactory.createLineBorder(blue));
        this.gameMasterTextArea.setDisabledTextColor(yellow);
        this.gameMasterTextArea.setBackground(java.awt.Color.BLACK);
        this.gameMasterTextArea.setFont(f);
        tabbedPane_1.addTab("GameMaster", null, this.gameMasterTextArea, null);
        this.playerInfoTextArea = new JTextArea();
        this.playerInfoTextArea.setEnabled(false);
        this.playerInfoTextArea.setEditable(false);
        this.playerInfoTextArea.setBorder(BorderFactory.createLineBorder(blue));
        this.playerInfoTextArea.setDisabledTextColor(yellow);
        this.playerInfoTextArea.setBackground(java.awt.Color.BLACK);
        this.playerInfoTextArea.setFont(f);
        tabbedPane_1.addTab("PlayerInfo", null, this.playerInfoTextArea, null);
        notePanel.setLayout(gl_notePanel);
        GroupLayout gl_controlPanel = new GroupLayout(controlPanel);
        gl_controlPanel.setHorizontalGroup(gl_controlPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_controlPanel.createSequentialGroup().addGroup(gl_controlPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(notePanel, -1, 197, Short.MAX_VALUE).addComponent(buttonPanel, -1, 197, Short.MAX_VALUE)).addGap(2)));
        gl_controlPanel.setVerticalGroup(gl_controlPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, gl_controlPanel.createSequentialGroup().addComponent(notePanel, -1, 393, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(buttonPanel, -1, 422, Short.MAX_VALUE)));
        this.btnConnect = new JButton("Connect");
        this.btnConnect.setBackground(java.awt.Color.BLACK);
        this.btnConnect.setForeground(yellow);
        this.btnConnect.setBorder(BorderFactory.createLineBorder(blue));
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ClientGUI.this.connectButtonGetClicked();
            }
        });
        this.btnDisconnect = new JButton("Disconnect");
        this.btnDisconnect.setBackground(java.awt.Color.BLACK);
        this.btnDisconnect.setForeground(yellow);
        this.btnDisconnect.setBorder(BorderFactory.createLineBorder(blue));
        this.btnDisconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientGUI.this.disconnectButtonGetClicked();
            }
        });
        this.btnJoin = new JButton("Join");
        this.btnJoin.setBackground(java.awt.Color.BLACK);
        this.btnJoin.setForeground(yellow);
        this.btnJoin.setBorder(BorderFactory.createLineBorder(blue));
        this.btnJoin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientGUI.this.joinButtonGetClicked();
            }
        });
        this.btnBegin = new JButton("Begin");
        this.btnBegin.setBackground(java.awt.Color.BLACK);
        this.btnBegin.setForeground(yellow);
        this.btnBegin.setBorder(BorderFactory.createLineBorder(blue));
        this.btnBegin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientGUI.this.beginButtonGetClicked();
            }
        });
        this.btnHighscore = new JButton("Highscore");
        this.btnHighscore.setBackground(java.awt.Color.BLACK);
        this.btnHighscore.setForeground(yellow);
        this.btnHighscore.setBorder(BorderFactory.createLineBorder(blue));
        this.btnHighscore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientGUI.this.highScoreButtonGetClicked();
            }
        });
        this.btnManual = new JButton("Manual");
        this.btnManual.setBackground(java.awt.Color.BLACK);
        this.btnManual.setForeground(yellow);
        this.btnManual.setBorder(BorderFactory.createLineBorder(blue));
        this.btnManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientGUI.this.manualButtonGetClicked();
            }
        });
        this.btnChangeName = new JButton("Change Name");
        this.btnChangeName.setBackground(java.awt.Color.BLACK);
        this.btnChangeName.setForeground(yellow);
        this.btnChangeName.setBorder(BorderFactory.createLineBorder(blue));
        this.btnChangeName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ClientGUI.this.changeNameButtonGetClicked();
            }
        });
        GroupLayout gl_buttonPanel = new GroupLayout(buttonPanel);
        gl_buttonPanel.setHorizontalGroup(gl_buttonPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_buttonPanel.createSequentialGroup().addGap(33).addGroup(gl_buttonPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnChangeName, GroupLayout.Alignment.TRAILING, -1, 154, Short.MAX_VALUE).addComponent(this.btnManual, GroupLayout.Alignment.TRAILING, -1, 154, Short.MAX_VALUE).addComponent(this.btnHighscore, GroupLayout.Alignment.TRAILING, -1, 154, Short.MAX_VALUE).addComponent(this.btnJoin, GroupLayout.Alignment.TRAILING, -1, 154, Short.MAX_VALUE).addComponent(this.btnDisconnect, GroupLayout.Alignment.TRAILING, -1, 154, Short.MAX_VALUE).addComponent(this.btnConnect, GroupLayout.Alignment.TRAILING, -1, 154, Short.MAX_VALUE).addComponent(this.btnBegin, GroupLayout.Alignment.TRAILING, -1, 154, Short.MAX_VALUE)).addContainerGap()));
        gl_buttonPanel.setVerticalGroup(gl_buttonPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_buttonPanel.createSequentialGroup().addContainerGap().addComponent(this.btnConnect, -1, 51, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDisconnect, -1, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnJoin, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBegin, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnHighscore, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnManual, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnChangeName, -1, 50, Short.MAX_VALUE).addGap(70)));
        buttonPanel.setLayout(gl_buttonPanel);
        controlPanel.setLayout(gl_controlPanel);
        this.rootPanel.setLayout(gl_rootPanel);
        this.getContentPane().setLayout(groupLayout);
        this.initButtons();
    }

    private void startGL() {
        this.textures = new HashMap();
        this.WIDTH = 660;
        this.HEIGHT = 880;
        this.glThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ClientGUI.this.isRunning = true;
                try {
                    Display.setDisplayMode(new DisplayMode(ClientGUI.this.WIDTH, ClientGUI.this.HEIGHT));
                    Display.create();
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                }
                GL11.glMatrixMode(5889);
                GL11.glLoadIdentity();
                GL11.glOrtho(0.0, ClientGUI.this.WIDTH, ClientGUI.this.HEIGHT, 0.0, 1.0, -1.0);
                GL11.glMatrixMode(5888);
                GL11.glEnable(3553);
                GL11.glEnable(3042);
                GL11.glBlendFunc(770, 771);
                while (ClientGUI.this.isRunning) {
                    Dimension newDim = newCanvasSize.getAndSet(null);
                    if (newDim != null) {
                        GL11.glViewport(0, 0, newDim.width, newDim.height);
                    }
                    GL11.glClear(16384);
                    try {
                        if (ClientGUI.this.map != null) {
                            ClientGUI.this.paint();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Display.update();
                    Display.sync(20);
                    ClientGUI.this.checkKeyboard();
                }
                Display.destroy();
            }
        }, "LWJGL Thread");
        this.glThread.start();
    }

    private void stopGL() {
        this.isRunning = false;
        try {
            this.glThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint() throws IOException, InterruptedException {
        GL11.glClear(16384);
        this.drawWalls(this.map.Walls);
        this.intersectionWalls(this.map.Walls);
        this.drawWalls(this.map.Spawn);
        this.intersectionWalls(this.map.Spawn);
        this.drawGate(this.map.gate);
        this.lock.lock();
        List<Ball> list = this.map.Balls;
        synchronized (list) {
            try {
                this.drawPowerballs(this.map.PowerBalls);
                this.drawBall(this.map.Balls);
            }
            finally {
                this.lock.unlock();
            }
        }
        this.drawActors(this.client.getActors(), this.client.getGameState());
        if (this.finish) {
            this.handleGameFinish(this.finishResult);
        }
        this.initFont();
        this.render(this.client.getGameState().scorePacMan, this.client.getGameState().scoreGhost);
    }

    private void drawActors(HashMap<String, Player> actorsPos, GameState gameState) throws IOException {
        Set<String> keys = actorsPos.keySet();
        for (String k : keys) {
            Player actor = actorsPos.get(k);
            if (actor instanceof PacMan) {
                this.drawPacMan((PacMan)actor);
            }
            if (!(actor instanceof Ghost)) continue;
            this.drawGhost((Ghost)actor, gameState);
        }
    }

    private void drawPacMan(PacMan pacMan) throws IOException {
        this.tex = this.quickLoad("PacMan");
        float x = pacMan.position.x;
        float y = pacMan.position.y;
        switch (pacMan.direction) {
            case left: {
                this.drawQuadTex(this.tex, x, y, 20.0f, 20.0f, -180.0f);
                break;
            }
            case right: {
                this.drawQuadTex(this.tex, x, y, 20.0f, 20.0f, 0.0f);
                break;
            }
            case up: {
                this.drawQuadTex(this.tex, x, y, 20.0f, 20.0f, -90.0f);
                break;
            }
            case down: {
                this.drawQuadTex(this.tex, x, y, 20.0f, 20.0f, 90.0f);
                break;
            }
        }
    }

    private void drawGhost(Ghost ghost, GameState gameState) throws IOException {
        Texture tex = null;
        if (gameState.superPower > 0) {
            tex = this.quickLoad("Ghost_fear");
        } else {
            switch (ghost.color) {
                case blue: {
                    tex = this.quickLoad("Ghost_blue");
                    break;
                }
                case red: {
                    tex = this.quickLoad("Ghost_red");
                    break;
                }
                case pink: {
                    tex = this.quickLoad("Ghost_pink");
                    break;
                }
                case yellow: {
                    tex = this.quickLoad("Ghost_yellow");
                    break;
                }
            }
        }
        float x = ghost.position.x;
        float y = ghost.position.y;
        this.drawQuadTex(tex, x, y, 20.0f, 20.0f);
    }

    private void drawGate(Gate gate) throws IOException {
        this.tex = this.quickLoad("Tor");
        float x = gate.position.x;
        float y = gate.position.y;
        this.drawQuadTex(this.tex, x, y, 20.0f, 20.0f);
    }

    private synchronized void drawBall(List<Ball> pBalls) throws IOException {
        this.tex = this.quickLoad("Kleiner_Punkt");
        for (int i = 0; i < pBalls.size(); ++i) {
            float x = pBalls.get((int)i).position.x;
            float y = pBalls.get((int)i).position.y;
            this.drawQuadTex(this.tex, x, y, 20.0f, 20.0f);
        }
    }

    private synchronized void drawPowerballs(List<PowerBall> pBalls) throws IOException {
        this.tex = this.quickLoad("Grosser_Punkt");
        for (PowerBall powerBall : pBalls) {
            float x = powerBall.position.x;
            float y = powerBall.position.y;
            this.drawQuadTex(this.tex, x, y, 20.0f, 20.0f);
        }
    }

    private void drawWalls(List<Wall> Walls) throws IOException {
        for (Wall w : Walls) {
            int i;
            Point2D.Float[] pointArray = new Point2D.Float[w.points.size()];
            for (i = 0; i < pointArray.length; ++i) {
                pointArray[i] = w.points.get(i);
            }
            for (i = 0; i < pointArray.length; ++i) {
                if (i < pointArray.length - 1) {
                    if (pointArray[i].x + 1.0f == pointArray[i + 1].x) {
                        this.tex = this.quickLoad("Horizontal");
                        this.x = pointArray[i].x;
                        this.y = pointArray[i].y;
                        this.drawQuadTex(this.tex, this.x, this.y, 20.0f, 20.0f);
                    } else if (pointArray[i].y + 1.0f == pointArray[i + 1].y) {
                        this.tex = this.quickLoad("Vertical");
                        this.x = pointArray[i].x;
                        this.y = pointArray[i].y;
                        this.drawQuadTex(this.tex, this.x, this.y, 20.0f, 20.0f);
                    }
                }
                if (i <= 0) continue;
                if (pointArray[i].x - 1.0f == pointArray[i - 1].x) {
                    this.tex = this.quickLoad("Horizontal");
                    this.x = pointArray[i].x;
                    this.y = pointArray[i].y;
                    this.drawQuadTex(this.tex, this.x, this.y, 20.0f, 20.0f);
                    continue;
                }
                if (pointArray[i].y - 1.0f != pointArray[i - 1].y) continue;
                this.tex = this.quickLoad("Vertical");
                this.x = pointArray[i].x;
                this.y = pointArray[i].y;
                this.drawQuadTex(this.tex, this.x, this.y, 20.0f, 20.0f);
            }
        }
    }

    private void checkCorners(Point2D.Float point3, List<Point2D.Float> points) throws IOException {
        for (Point2D.Float point : points) {
            if (point.getX() == point3.getX() + 1.0 && point.getY() == point3.getY()) {
                for (Point2D.Float point1 : points) {
                    if (point1.getX() == point3.getX() && point1.getY() == point3.getY() + 1.0) {
                        this.tex = this.quickLoad("Rechts_Unten_Kurve");
                        this.drawQuadTex(this.tex, point3.x, point3.y, 20.0f, 20.0f);
                    }
                    if (point1.getX() != point3.getX() || point1.getY() + 1.0 != point3.getY()) continue;
                    this.tex = this.quickLoad("Oben_Rechts_Kurve");
                    this.drawQuadTex(this.tex, point3.x, point3.y, 20.0f, 20.0f);
                }
            }
            if (point.getX() != point3.getX() - 1.0 || point.getY() != point3.getY()) continue;
            for (Point2D.Float point2 : points) {
                if (point2.getX() == point3.getX() && point2.getY() + 1.0 == point3.getY()) {
                    this.tex = this.quickLoad("Links_Oben_Kurve");
                    this.drawQuadTex(this.tex, point3.x, point3.y, 20.0f, 20.0f);
                }
                if (point2.getX() != point3.getX() || point2.getY() - 1.0 != point3.getY()) continue;
                this.tex = this.quickLoad("Links_Unten_Kurve");
                this.drawQuadTex(this.tex, point3.x, point3.y, 20.0f, 20.0f);
            }
        }
    }

    private void intersectionWalls(List<Wall> Walls) throws IOException {
        int i;
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        for (Wall w : Walls) {
            Point2D.Float[] pointArray = new Point2D.Float[w.points.size()];
            for (i = 0; i < pointArray.length; ++i) {
                pointArray[i] = w.points.get(i);
                points.add(pointArray[i]);
            }
        }
        for (Point2D.Float point : points) {
            int j;
            for (i = j = 0; i < points.size(); ++i) {
                if (point != points.get(i)) continue;
                this.checkCorners(point, points);
            }
            ++j;
        }
    }

    private Texture loadTexture(String path, String fileType) throws IOException {
        if (this.textures.containsKey(path)) {
            return this.textures.get(path);
        }
        System.out.println(path);
        Texture tex = null;
        InputStream in = ResourceLoader.getResourceAsStream(path);
        tex = TextureLoader.getTexture(fileType, in);
        this.textures.put(path, tex);
        return tex;
    }

    private Texture quickLoad(String name) throws IOException {
        Texture tex = null;
        tex = this.loadTexture("resources/" + name + ".png", "PNG");
        return tex;
    }

    private void drawQuadTex(Texture tex, float x, float y, float width, float height) {
        tex.bind();
        GL11.glTranslatef(x * 20.0f, y * 20.0f, 0.0f);
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex2f(0.0f, 0.0f);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex2f(width, 0.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex2f(width, height);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex2f(0.0f, height);
        GL11.glEnd();
        GL11.glLoadIdentity();
    }

    public void initFont() {
        Font awtFont = new Font("Times New Roman", 1, 18);
        this.font = new TrueTypeFont(awtFont, this.antiAlias);
        try {
            InputStream inputStream = ResourceLoader.getResourceAsStream("myfont.ttf");
            Font awtFont2 = Font.createFont(0, inputStream);
            awtFont2 = awtFont2.deriveFont(20.0f);
            this.font2 = new TrueTypeFont(awtFont2, this.antiAlias);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void render(int scorePacMan, int scoreGhost) {
        Color.white.bind();
        this.font.drawString(20.0f, 20.0f, "Score PacMan: " + Integer.toString(scorePacMan), Color.white);
        this.font.drawString(520.0f, 20.0f, "Score Ghost: " + Integer.toString(scoreGhost), Color.white);
    }

    private void gameOverText(int score, String text) {
        this.render(score, text);
    }

    public void render(int score, String text) {
        Color.black.bind();
        this.font.drawString(280.0f, 400.0f, text, Color.white);
        this.font.drawString(280.0f, 430.0f, "Score: " + Integer.toString(score), Color.white);
    }

    private void drawQuadTex(Texture tex, float x, float y, float width, float height, float rotation) {
        tex.bind();
        GL11.glTranslatef(x * 20.0f, y * 20.0f, 0.0f);
        GL11.glTranslatef(10.0f, 10.0f, 0.0f);
        GL11.glRotatef(rotation, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-10.0f, -10.0f, 0.0f);
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex2f(0.0f, 0.0f);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex2f(width, 0.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex2f(width, height);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex2f(0.0f, height);
        GL11.glEnd();
        GL11.glLoadIdentity();
    }

    private void initButtons() {
        this.btnConnect.setEnabled(true);
        this.btnJoin.setEnabled(false);
        this.btnBegin.setEnabled(false);
        this.btnSend.setEnabled(false);
        this.btnDisconnect.setEnabled(false);
        this.btnBroadcast.setEnabled(false);
        this.btnWhisper.setEnabled(false);
        this.btnHighscore.setEnabled(false);
        this.btnManual.setEnabled(false);
        this.btnChangeName.setEnabled(false);
    }

    void initName(String myName) {
        this.myName = myName;
        this.updatePlayerInfo();
    }

    void updatePlayerInfo() {
        this.playerInfoTextArea.setText("");
        this.playerInfoTextArea.append("Name: " + this.myName + System.lineSeparator());
        this.playerInfoTextArea.append("Connection: " + this.client.isConnected() + System.lineSeparator());
        this.playerInfoTextArea.append("Lobby: " + this.client.getLobby() + System.lineSeparator());
    }

    static ClientGUI initGUI() {
        ClientGUI frame = new ClientGUI();
        frame.setTitle("PacMan Reloaded");
        frame.setVisible(true);
        return frame;
    }

    private void manualButtonGetClicked() {
        this.client.sendGetManual();
    }

    private void highScoreButtonGetClicked() {
        this.client.sendGetHighScore();
    }

    private void changeNameButtonGetClicked() {
        if (this.client.isConnected()) {
            String name = JOptionPane.showInputDialog(this.rootPanel, "Name: ", null);
            if (name != null && !name.equals("")) {
                this.client.changeName(name);
            }
        } else {
            this.gameMasterTextArea.append("Du musst dich mit dem Server verbinden!" + System.lineSeparator());
        }
    }

    private void beginButtonGetClicked() {
        if (this.client.isClientInLobby()) {
            this.client.sendBeginGame();
            this.btnBegin.setEnabled(false);
        } else {
            this.gameMasterTextArea.append("Die Lobby-Anfrage hat nicht geklappt.\nBitte w\u00e4hle eine andere Lobby!" + System.lineSeparator());
            this.btnBegin.setEnabled(false);
        }
    }

    private void joinButtonGetClicked() {
        if (this.client.isConnected()) {
            String lobby = JOptionPane.showInputDialog(this.rootPanel, "Lobby: ", null);
            if (lobby != null && !lobby.equals("")) {
                this.client.sendJoinLobbyMessage(lobby);
                this.finish = false;
                this.finishResult = "";
            }
        } else {
            this.gameMasterTextArea.append("Du musst dich mit dem Server verbinden!" + System.lineSeparator());
        }
    }

    private void sendButtonGetClicked() {
        String input = this.chatInputTextField.getText();
        if (input.length() > 0) {
            this.chatInputTextField.setText("");
            this.client.handleSendRequest(input);
        }
    }

    private void whisperButtonGetClicked() {
        String message = this.chatInputTextField.getText();
        String receiver = JOptionPane.showInputDialog(this.rootPanel, (Object)"Message should be send to?");
        if (message.length() > 0 && receiver.length() > 0) {
            this.chatInputTextField.setText("");
            this.client.handleWhisperRequest(receiver + " " + message);
        }
    }

    private void broadcastButtonGetClicked() {
        String input = this.chatInputTextField.getText();
        if (input.length() > 0) {
            this.chatInputTextField.setText("");
            this.client.sendChatMessage(input);
        }
    }

    private void connectButtonGetClicked() {
        if (!this.client.isConnected()) {
            if (this.client.connectToServer()) {
                JOptionPane.showMessageDialog(this.rootPanel, "Connection established!");
                this.gameMasterTextArea.setText("");
                this.btnDisconnect.setEnabled(true);
                this.btnJoin.setEnabled(true);
                this.btnConnect.setEnabled(false);
                this.btnSend.setEnabled(true);
                this.btnBroadcast.setEnabled(true);
                this.btnWhisper.setEnabled(true);
                this.chatInputTextField.setEnabled(true);
                this.btnHighscore.setEnabled(true);
                this.btnManual.setEnabled(true);
                this.btnChangeName.setEnabled(true);
                this.updatePlayerInfo();
            } else {
                JOptionPane.showMessageDialog(this.rootPanel, "Cannot established connection to " + this.client.serverAddress + " at port " + this.client.serverPort);
            }
        }
    }

    private void disconnectButtonGetClicked() {
        this.client.disconnectFromServer();
        this.disconnect();
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void disconnect() {
        this.playerInfoTextArea.setText("");
        this.initButtons();
        this.gameMasterTextArea.setText("");
        this.gameMasterTextArea.append("Sie sind disconnected.");
        this.chatInputTextField.setEnabled(false);
    }

    void handleBeginFailed() {
        this.gameMasterTextArea.append("Du bist momentan alleine in der Lobby.\nWarte auf weiterne Spieler.");
        this.btnBegin.setEnabled(true);
    }

    void handleLobbyResponse(boolean response) {
        if (response) {
            this.btnBegin.setEnabled(true);
            this.btnJoin.setEnabled(false);
            this.updatePlayerInfo();
        } else {
            this.gameMasterTextArea.append("Die Lobby-Anfrage hat nicht geklappt.\nBitte w\u00e4hle eine andere Lobby!" + System.lineSeparator());
        }
    }

    public void handleChat(ChatMessage chatMessage) {
        this.chatTextArea.append(chatMessage.getFrom() + ": " + chatMessage.getInfo() + System.lineSeparator());
        this.playSoundChat();
    }

    public void handleChatToMeMessage(ChatWithAddress chatToMeMessage) {
        this.chatTextArea.append(chatToMeMessage.getAddress() + ": " + chatToMeMessage.getInfo() + System.lineSeparator());
        this.playSoundChat();
    }

    public void handleHighScore(String paramValue) {
        InformationGUI.initInformationGUI(paramValue, this.size(), "High Score");
    }

    public void handleManual(String paramValue) {
        InformationGUI.initInformationGUI(paramValue, this.size(), "Manual");
    }

    public void handleGameFinish(String answer) {
        if (answer.equals("WON")) {
            if (this.client.getGameState().scorePacMan > this.client.getGameState().scoreGhost) {
                this.gameOverText(this.client.getGameState().scorePacMan, "You Win");
            }
            if (this.client.getGameState().scorePacMan <= this.client.getGameState().scoreGhost) {
                this.gameOverText(this.client.getGameState().scoreGhost, "You Win");
            }
        }
        if (answer.equals("LOSE")) {
            if (this.client.getGameState().scorePacMan <= this.client.getGameState().scoreGhost) {
                this.gameOverText(this.client.getGameState().scorePacMan, "You Lose");
            }
            if (this.client.getGameState().scorePacMan > this.client.getGameState().scoreGhost) {
                this.gameOverText(this.client.getGameState().scoreGhost, "You Lose");
            }
        }
    }

    public void playSoundFinishedGame() {
        try {
            File soundFile = new File("resources/personen_yeeaaa.wav");
            this.playSound(soundFile);
        }
        catch (Exception e) {
            System.out.println("Sound could not be loaded");
        }
    }

    public void playSound(File soundFile) {
        try {
            AudioInputStream audioIn = AudioSystem.getAudioInputStream(soundFile);
            Clip clip = AudioSystem.getClip();
            clip.open(audioIn);
            clip.start();
        }
        catch (Exception e) {
            System.out.println("Sound could not be played");
        }
    }

    public void playSoundChat() {
        try {
            File soundFile = new File("resources/personen_husten.wav");
            this.playSound(soundFile);
        }
        catch (Exception e) {
            System.out.println("Sound could not be loaded");
        }
    }

    public void setGameFinish(String answer) {
        this.finish = true;
        this.finishResult = answer;
        this.playSoundFinishedGame();
        this.btnJoin.setEnabled(true);
    }

    public void setLobbyInfo(String serverInfo) {
        this.lobbyTextArea.setText(serverInfo);
    }

    public void setClientInfo(String serverInfo) {
        this.clientsTextArea.setText(serverInfo);
    }

    public void paintMap(Map map) {
        this.map = map;
    }

    public void checkKeyboard() {
        if (Keyboard.isKeyDown(203)) {
            this.client.tryToChangeDirection("left");
        }
        if (Keyboard.isKeyDown(205)) {
            this.client.tryToChangeDirection("right");
        }
        if (Keyboard.isKeyDown(200)) {
            this.client.tryToChangeDirection("up");
        }
        if (Keyboard.isKeyDown(208)) {
            this.client.tryToChangeDirection("down");
        }
    }
}

