/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.client;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import pacManReloaded.client.ClientThread;
import pacManReloaded.common.Command;
import pacManReloaded.common.CommandFactory;
import pacManReloaded.common.messages.ChatMessage;
import pacManReloaded.common.messages.ChatWithAddress;
import pacManReloaded.common.messages.GameFinishedMessage;
import pacManReloaded.common.messages.IMessage;
import pacManReloaded.common.messages.MapMessage;
import pacManReloaded.common.messages.NoParameterMessage;
import pacManReloaded.common.messages.SingleStringParameterMessage;

public class ClientProtocol {
    private String toReadableTime(long timeInms) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date resultDate = new Date(timeInms);
        return sdf.format(resultDate);
    }

    void handleMsg(ClientThread thread, IMessage gameMsg) {
        switch (gameMsg.getType()) {
            case MESSAGE: {
                ChatMessage chatMessage = (ChatMessage)gameMsg;
                thread.handleChat(chatMessage);
                break;
            }
            case SEND_TO_ADDRESS: {
                ChatWithAddress specificMessage = (ChatWithAddress)gameMsg;
                thread.handleChatToMeMessage(specificMessage);
                break;
            }
            case GAME_FINISHED: {
                GameFinishedMessage gameFinishedMessage = (GameFinishedMessage)gameMsg;
                thread.handleGameFinish(gameFinishedMessage);
                break;
            }
            case PING: {
                NoParameterMessage pongMsg = new NoParameterMessage(Command.PONG);
                thread.send(pongMsg);
                System.out.println("Pong sent as answer at: " + this.toReadableTime(System.currentTimeMillis()));
                break;
            }
            case PONG: {
                thread.updateLastContact();
                System.out.println("Received a Pong from Server at: " + this.toReadableTime(System.currentTimeMillis()));
                break;
            }
            case CLOSE: {
                thread.close();
                break;
            }
            case GET_NICKNAME: {
                String myName = thread.getMyName();
                ArrayList<String> params = new ArrayList<String>();
                params.add(myName);
                IMessage myNameMsg = CommandFactory.createMessage(Command.MY_NICKNAME, params);
                thread.send(myNameMsg);
                break;
            }
            case HIGHSCORE: {
                SingleStringParameterMessage hScoreMsg = (SingleStringParameterMessage)gameMsg;
                thread.handleServerHighScore(hScoreMsg.getParamValue());
                break;
            }
            case MAP: {
                MapMessage mapMessage = (MapMessage)gameMsg;
                thread.handleMap(mapMessage);
                break;
            }
            case MANUAL: {
                SingleStringParameterMessage manualMsg = (SingleStringParameterMessage)gameMsg;
                thread.handleManual(manualMsg.getParamValue());
                break;
            }
            case LOBBY_INFO: {
                SingleStringParameterMessage infoMsg = (SingleStringParameterMessage)gameMsg;
                thread.handleServerLobbyInfo(infoMsg.getParamValue());
                break;
            }
            case CLIENT_INFO: {
                SingleStringParameterMessage infoMsg = (SingleStringParameterMessage)gameMsg;
                thread.handleServerClientInfo(infoMsg.getParamValue());
                break;
            }
            case SET_NICKNAME: {
                SingleStringParameterMessage newName = (SingleStringParameterMessage)gameMsg;
                thread.setMyName(newName.getParamValue());
                break;
            }
            case JOIN_LOBBY_RESPONSE: {
                SingleStringParameterMessage joinLobby = (SingleStringParameterMessage)gameMsg;
                thread.handleJoinLobbyResponse(joinLobby.getParamValue());
                break;
            }
            case INIT_PLAYER: {
                SingleStringParameterMessage initPlayer = (SingleStringParameterMessage)gameMsg;
                thread.handleActorInit(initPlayer.getParamValue());
                break;
            }
            case ACTOR_POSITION: {
                SingleStringParameterMessage actorPos = (SingleStringParameterMessage)gameMsg;
                thread.handleActorPos(actorPos.getParamValue());
                break;
            }
            case INIT_GAMESTATE: {
                SingleStringParameterMessage initGameState = (SingleStringParameterMessage)gameMsg;
                thread.handleInitGameState(initGameState.getParamValue());
                break;
            }
            case GAMESTATE: {
                SingleStringParameterMessage gameState = (SingleStringParameterMessage)gameMsg;
                thread.handleGameState(gameState.getParamValue());
                break;
            }
            case REMOVE_OBJECT: {
                SingleStringParameterMessage removeObjectMsg = (SingleStringParameterMessage)gameMsg;
                thread.handleRemoveObject(removeObjectMsg.getParamValue());
                break;
            }
            case UNKNOWN_MESSAGE: {
                System.out.println("This Command is not defined: " + gameMsg);
                break;
            }
            default: {
                System.out.println("Unknown Command: " + gameMsg);
            }
        }
    }
}

