/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import pacManReloaded.client.Client;
import pacManReloaded.client.ClientProtocol;
import pacManReloaded.common.CommandFactory;
import pacManReloaded.common.JoinLobbyResult;
import pacManReloaded.common.messages.ChatMessage;
import pacManReloaded.common.messages.ChatWithAddress;
import pacManReloaded.common.messages.GameFinishedMessage;
import pacManReloaded.common.messages.IMessage;
import pacManReloaded.common.messages.MapMessage;

public class ClientThread
extends Thread {
    private Socket socket;
    private Client client;
    private BufferedReader streamIn = null;
    private BufferedWriter streamOut = null;
    private ClientProtocol protocol = new ClientProtocol();
    private long lastContact;
    private String nickname;
    private String myLobby;

    public ClientThread(Client _client, Socket _socket, String myName) {
        this.client = _client;
        this.socket = _socket;
        this.nickname = myName;
        this.myLobby = null;
        this.open();
        this.start();
        this.lastContact = System.currentTimeMillis();
    }

    @Override
    public void run() {
        try {
            String msg;
            while ((msg = this.streamIn.readLine()) != null) {
                System.out.println("Message received: " + msg + " at: " + this.toReadableTime(System.currentTimeMillis()));
                IMessage gameMsg = CommandFactory.parseMessage(msg);
                this.protocol.handleMsg(this, gameMsg);
            }
            System.out.println("End of stream reached!");
        }
        catch (IOException ioe) {
            System.out.println("Listening error: " + ioe.getMessage());
        }
        this.close();
    }

    public void send(IMessage msg) {
        try {
            this.streamOut.write(msg + System.lineSeparator());
            this.streamOut.flush();
        }
        catch (IOException ioe) {
            System.out.println("ERROR sending: " + ioe.getMessage());
        }
    }

    private void open() {
        try {
            this.streamIn = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "utf-8"));
            this.streamOut = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "utf-8"));
        }
        catch (IOException ioe) {
            System.out.println("Error getting input stream: " + ioe);
            this.client.stopThread();
        }
    }

    public void close() {
        System.out.println("Goodbye.");
        this.clearInfo();
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            if (this.streamIn != null) {
                this.streamIn.close();
                this.streamIn = null;
            }
            if (this.streamOut != null) {
                this.streamOut.close();
                this.streamOut = null;
            }
            this.client.stopThread();
        }
        catch (IOException ioe) {
            System.out.println("Error closing input stream: " + ioe);
        }
    }

    private void clearInfo() {
        this.nickname = null;
        this.lastContact = 0L;
    }

    private String toReadableTime(long timeInms) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date resultDate = new Date(timeInms);
        return sdf.format(resultDate);
    }

    public void handleChat(ChatMessage chatMessage) {
        this.client.forwardChat(chatMessage);
        System.out.println("Received messages '" + chatMessage.getInfo() + "' from " + chatMessage.getFrom());
    }

    public void handleMap(MapMessage mapMessage) {
        try {
            this.client.handleMap(mapMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleActorPos(String parm) {
        this.client.handleActorPos(parm);
    }

    public void handleActorInit(String paramValue) {
        this.client.handleActorInit(paramValue);
    }

    public void handleChatToMeMessage(ChatWithAddress chatToMeMessage) {
        this.client.forwardChatToMeMessage(chatToMeMessage);
        System.out.println("Received chat to me message '" + chatToMeMessage.getInfo() + "' from " + chatToMeMessage.getAddress());
    }

    public void handleServerLobbyInfo(String serverInfo) {
        System.out.println("Server info...");
        serverInfo = serverInfo.replace("|", System.lineSeparator());
        this.client.forwardLobbyInfo(serverInfo);
        System.out.println(serverInfo);
    }

    public void handleServerClientInfo(String serverInfo) {
        System.out.println("Server info...");
        serverInfo = serverInfo.replace("|", System.lineSeparator());
        this.client.forwardClientInfo(serverInfo);
        System.out.println(serverInfo);
    }

    public void handleJoinLobbyResponse(String lobbyResponseResult) {
        try {
            JoinLobbyResult lobbyState = JoinLobbyResult.valueOf(lobbyResponseResult);
            switch (lobbyState) {
                case Created: 
                case Joined: {
                    this.client.forwardJoinLobbyResponse(true);
                    System.out.println("Joined lobby: " + lobbyResponseResult);
                    break;
                }
                case Rejected: 
                case AlreadyPlaying: {
                    this.client.forwardJoinLobbyResponse(false);
                    System.out.println("Cannot join lobby " + this.myLobby + ": " + lobbyResponseResult);
                    this.myLobby = null;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Unknown lobby response: " + lobbyResponseResult);
            this.myLobby = null;
        }
    }

    public void handleServerHighScore(String paramValue) {
        System.out.println("Server info...");
        paramValue = paramValue.replace("|", System.lineSeparator());
        this.client.forwardHighScore(paramValue);
        System.out.println(paramValue);
    }

    public void handleManual(String paramValue) {
        paramValue = paramValue.replace("|", System.lineSeparator());
        this.client.forwardManual(paramValue);
    }

    public void handleInitGameState(String paramValue) {
        this.client.handleInitGameState(paramValue);
    }

    public void handleGameState(String paramValue) {
        this.client.handleGameState(paramValue);
    }

    public void handleRemoveObject(String paramValue) {
        this.client.handleRemoveObject(paramValue);
    }

    public void handleBeginFailed() {
        this.client.forwardBeginFailed();
    }

    public void handleGameFinish(GameFinishedMessage gameFinishedMessage) {
        this.client.handleGameFinish(gameFinishedMessage);
    }

    public void updateLastContact() {
        this.lastContact = System.currentTimeMillis();
    }

    public String getMyName() {
        return this.nickname;
    }

    public long getLastContact() {
        return this.lastContact;
    }

    public void setMyName(String myName) {
        this.nickname = myName;
        this.client.forwardName(myName);
    }

    public String getMyLobby() {
        return this.myLobby;
    }

    public void setMyLobby(String myLobby) {
        this.myLobby = myLobby;
    }
}

