/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.common;

import pacManReloaded.client.Client;
import pacManReloaded.server.Server;

public class Main {
    public static void main(String[] args) {
        if (args.length > 0) {
            Main.handleArgs(args);
        } else {
            System.out.println("Not enough args.");
        }
    }

    private static void handleArgs(String[] args) {
        if (args[0].equals("server")) {
            Main.createServer(args);
        } else if (args[0].equals("client")) {
            Main.createClient(args);
        } else {
            System.err.println("Expected Arguments:\nclient <hostadress>: <port> (<username>) | server <port>");
            System.exit(1);
        }
    }

    private static void createClient(String[] args) {
        switch (args.length) {
            case 2: {
                Main.createClient(args, "");
                break;
            }
            case 3: {
                Main.createClient(args, args[2]);
                break;
            }
            default: {
                System.err.println("Expected Arguments:\nclient <hostadress>: <port> (<username>) | server <port>");
                System.exit(1);
            }
        }
    }

    private static void createServer(String[] args) {
        int port = 0;
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e232) {
            System.err.println("invalid Port.");
            System.exit(1);
        }
        if (1023 >= port || port >= 49152) {
            System.err.println("invalid portnumber");
            System.exit(1);
        }
        Server server = new Server(port);
    }

    private static void createClient(String[] args, String name) {
        try {
            String[] address = args[1].split(":");
            String ipAddress = address[0];
            int port = Integer.parseInt(address[1]);
            if (1023 < port && port < 49152) {
                Client client = new Client(name, ipAddress, port);
            } else {
                System.err.println("invalid portnumber");
                System.exit(1);
            }
        }
        catch (NumberFormatException e434) {
            System.err.println("invalid portnumber");
            System.exit(1);
        }
    }
}

