/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.common.model;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import pacManReloaded.common.model.Ball;
import pacManReloaded.common.model.Gate;
import pacManReloaded.common.model.PowerBall;
import pacManReloaded.common.model.Wall;

public class Map {
    public List<Wall> Walls = new ArrayList<Wall>();
    public List<Wall> Spawn = new ArrayList<Wall>();
    public List<PowerBall> PowerBalls = new ArrayList<PowerBall>();
    public List<Ball> Balls = new ArrayList<Ball>();
    public Gate gate;
    public int xSize;
    public int ySize;
    public int tSize = 20;

    public boolean isFree(float f, float yStart) {
        if (f < 0.0f || f > (float)(this.xSize - 1) || yStart < 0.0f || yStart > (float)(this.ySize - 1)) {
            return false;
        }
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        for (PowerBall powerball : this.PowerBalls) {
            points.add(powerball.position);
        }
        for (Wall wall : this.Walls) {
            points.addAll(wall.points);
        }
        for (Wall spawn : this.Spawn) {
            points.addAll(spawn.points);
        }
        for (Ball ball : this.Balls) {
            points.add(ball.position);
        }
        points.add(this.gate.position);
        for (Point2D.Float point : points) {
            if (point.x != f || point.y != yStart) continue;
            return false;
        }
        return true;
    }

    public Object getObject(Point2D.Float actorPos) {
        Rectangle2D.Double rect;
        Point2D.Float displayPoint;
        ArrayList<Point2D.Float> points;
        Point2D.Float displayActorPos = this.Pos2DisplayPos(actorPos);
        Rectangle2D.Double actor = new Rectangle2D.Double(displayActorPos.getX() + (double)0.1f, displayActorPos.getY() + (double)0.1f, (float)this.tSize - 0.2f, (float)this.tSize - 0.2f);
        for (Wall wall : this.Walls) {
            points = new ArrayList<Point2D.Float>();
            points.addAll(wall.points);
            for (Point2D.Float point : points) {
                Point2D.Float displayPoint2 = this.Pos2DisplayPos(point);
                Rectangle2D.Double rect2 = new Rectangle2D.Double(((Point2D)displayPoint2).getX(), ((Point2D)displayPoint2).getY(), this.tSize, this.tSize);
                if (!rect2.intersects(actor)) continue;
                return wall;
            }
        }
        for (Wall wall : this.Spawn) {
            points = new ArrayList();
            points.addAll(wall.points);
            for (Point2D.Float point : points) {
                Point2D.Float displayPoint2 = this.Pos2DisplayPos(point);
                Rectangle2D.Double rect2 = new Rectangle2D.Double(((Point2D)displayPoint2).getX(), ((Point2D)displayPoint2).getY(), this.tSize, this.tSize);
                if (!rect2.intersects(actor)) continue;
                return wall;
            }
        }
        Point2D.Float displayPointGate = this.Pos2DisplayPos(this.gate.position);
        Rectangle2D.Double rectGate = new Rectangle2D.Double(((Point2D)displayPointGate).getX(), ((Point2D)displayPointGate).getY(), this.tSize, this.tSize);
        if (rectGate.intersects(actor)) {
            return this.gate;
        }
        for (Ball ball : this.Balls) {
            displayPoint = this.Pos2DisplayPos(ball.position);
            rect = new Rectangle2D.Double(((Point2D)displayPoint).getX() + 9.0, ((Point2D)displayPoint).getY() + 9.0, this.tSize - 18, this.tSize - 18);
            if (!rect.intersects(actor)) continue;
            return ball;
        }
        for (PowerBall powerBall : this.PowerBalls) {
            displayPoint = this.Pos2DisplayPos(powerBall.position);
            rect = new Rectangle2D.Double(((Point2D)displayPoint).getX() + 8.0, ((Point2D)displayPoint).getY() + 8.0, this.tSize - 16, this.tSize - 16);
            if (!rect.intersects(actor)) continue;
            return powerBall;
        }
        return null;
    }

    public Point2D.Float Pos2DisplayPos(Point2D.Float point) {
        return new Point2D.Float(point.x * (float)this.tSize, point.y * (float)this.tSize);
    }

    public float getMapSize() {
        return this.xSize;
    }

    public void removePowerBall(PowerBall o) {
        this.PowerBalls.remove(o);
    }

    public void removeBall(Ball o) {
        this.Balls.remove(o);
    }
}

