/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.common.model;

import java.awt.geom.Point2D;
import pacManReloaded.common.model.Direction;
import pacManReloaded.common.model.Gate;
import pacManReloaded.common.model.INavigator;
import pacManReloaded.common.model.Wall;
import pacManReloaded.server.Player;

public class PacMan
extends Player {
    private Direction nextDir;

    public PacMan(Point2D.Float point, INavigator nav, Point2D.Float startPoint, Player player) {
        super(player.getClient());
        this.position = point;
        this.navigator = nav;
        this.startPoint = startPoint;
        this.direction = Direction.right;
        this.speed = 0.2f;
        this.nextDir = Direction.none;
    }

    public PacMan(Point2D.Float point, INavigator nav, Point2D.Float startPoint) {
        this.position = point;
        this.navigator = nav;
        this.startPoint = startPoint;
        this.direction = Direction.right;
        this.speed = 0.2f;
        this.nextDir = Direction.none;
    }

    private void checkNextDirection() {
        if (this.nextDir == Direction.none) {
            return;
        }
        Object o = null;
        switch (this.nextDir) {
            case right: {
                o = this.navigator.getObjectAtPosition(new Point2D.Float(this.position.x + this.speed, this.position.y));
                break;
            }
            case left: {
                o = this.navigator.getObjectAtPosition(new Point2D.Float(this.position.x - this.speed, this.position.y));
                break;
            }
            case up: {
                o = this.navigator.getObjectAtPosition(new Point2D.Float(this.position.x, this.position.y - this.speed));
                break;
            }
            case down: {
                o = this.navigator.getObjectAtPosition(new Point2D.Float(this.position.x, this.position.y + this.speed));
                break;
            }
        }
        if (!(o instanceof Wall) && !(o instanceof Gate)) {
            this.direction = this.nextDir;
            this.nextDir = Direction.none;
        }
    }

    @Override
    public void nextMove() {
        this.checkNextDirection();
        this.changePosition();
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    public void changeDir(Direction dir) {
        this.nextDir = dir;
    }
}

