/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.server;

import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import pacManReloaded.common.model.Gate;
import pacManReloaded.common.model.Ghost;
import pacManReloaded.common.model.GhostColor;
import pacManReloaded.common.model.INavigator;
import pacManReloaded.common.model.Map;
import pacManReloaded.common.model.PacMan;
import pacManReloaded.common.model.PowerBall;
import pacManReloaded.common.model.Wall;
import pacManReloaded.server.Player;

public class GameLoader {
    private INavigator navigator;
    private ArrayList<Player> players;

    public GameLoader(INavigator nav, ArrayList<Player> players) {
        this.navigator = nav;
        this.players = players;
    }

    public GameLoader() {
    }

    public boolean load(String path, Map map, ArrayList<Player> actors) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        line = br.readLine();
        map.xSize = Integer.parseInt(line);
        line = br.readLine();
        map.ySize = Integer.parseInt(line);
        while (line != null) {
            line = br.readLine();
            if (line.contains("Wall:")) {
                line = br.readLine();
                while (!line.contains("PowerBall:")) {
                    map.Walls.add(this.createWall(line));
                    line = br.readLine();
                }
            }
            if (line.contains("PowerBall:")) {
                line = br.readLine();
                while (!line.contains("Gate:")) {
                    map.PowerBalls.addAll(this.createPowerBalls(line));
                    line = br.readLine();
                }
            }
            if (line.contains("Gate:")) {
                line = br.readLine();
                while (!line.contains("PacMan:")) {
                    map.gate = this.createGate(line);
                    line = br.readLine();
                }
            }
            if (line.contains("PacMan:")) {
                line = br.readLine();
                while (!line.contains("Ghost:")) {
                    PacMan p = this.createPacMan(line);
                    actors.remove(0);
                    actors.add(p);
                    line = br.readLine();
                }
            }
            if (line.contains("Ghost:")) {
                line = br.readLine();
                int i = 0;
                while (!line.contains("Spawn:")) {
                    Ghost g = this.createGhost(line);
                    g.color = GhostColor.values()[i % 4];
                    actors.remove(0);
                    actors.add(g);
                    ++i;
                    line = br.readLine();
                }
            }
            if (!line.contains("Spawn:")) continue;
            line = br.readLine();
            while (line != null) {
                map.Spawn.add(this.createWall(line));
                line = br.readLine();
            }
        }
        br.close();
        return true;
    }

    public Gate createGate(String line) {
        int x = 0;
        int y = 0;
        Point2D.Float point = null;
        String[] coordinated = line.split(",");
        x = Integer.parseInt(coordinated[0]);
        y = Integer.parseInt(coordinated[1]);
        point = new Point2D.Float(x, y);
        Gate gate = new Gate(point);
        return gate;
    }

    public Ghost createGhost(String line) {
        int x = 0;
        int y = 0;
        Point2D.Float point = null;
        String[] pointcoordinates = line.split(";");
        ArrayList<String[]> coordinates = new ArrayList<String[]>();
        for (int i = 0; i < pointcoordinates.length; ++i) {
            coordinates.add(pointcoordinates[i].split(","));
        }
        for (String[] strings : coordinates) {
            x = Integer.parseInt(strings[0]);
            y = Integer.parseInt(strings[1]);
            point = new Point2D.Float(x, y);
        }
        Ghost g = new Ghost(point, this.navigator, point, this.players.get(0));
        return g;
    }

    public List<PowerBall> createPowerBalls(String line) {
        int x = 0;
        int y = 0;
        Point2D.Float point = null;
        ArrayList<PowerBall> allBalls = new ArrayList<PowerBall>();
        String[] points = line.split(";");
        for (int i = 0; i < points.length; ++i) {
            String[] coordinates = points[i].split(",");
            x = Integer.parseInt(coordinates[0]);
            y = Integer.parseInt(coordinates[1]);
            point = new Point2D.Float(x, y);
            PowerBall powerBall = new PowerBall(point);
            allBalls.add(powerBall);
        }
        return allBalls;
    }

    public Wall createWall(String line) {
        int x = 0;
        int y = 0;
        Point2D.Float point = null;
        ArrayList<Point2D.Float> Points = new ArrayList<Point2D.Float>();
        String[] pointcoordinates = line.split(";");
        ArrayList<String[]> coordinates = new ArrayList<String[]>();
        for (int i = 0; i < pointcoordinates.length; ++i) {
            coordinates.add(pointcoordinates[i].split(","));
        }
        for (String[] strings : coordinates) {
            x = Integer.parseInt(strings[0]);
            y = Integer.parseInt(strings[1]);
            point = new Point2D.Float(x, y);
            Points.add(point);
        }
        Wall wall = new Wall(Points);
        return wall;
    }

    public PacMan createPacMan(String line) {
        int x = 0;
        int y = 0;
        Point2D.Float point = null;
        String[] pointcoordinates = line.split(";");
        ArrayList<String[]> coordinates = new ArrayList<String[]>();
        for (int i = 0; i < pointcoordinates.length; ++i) {
            coordinates.add(pointcoordinates[i].split(","));
        }
        for (String[] strings : coordinates) {
            x = Integer.parseInt(strings[0]);
            y = Integer.parseInt(strings[1]);
            point = new Point2D.Float(x, y);
        }
        PacMan pacMan = new PacMan(point, this.navigator, point, this.players.get(0));
        pacMan.setStartPoint(point);
        return pacMan;
    }
}

