/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.server;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import pacManReloaded.common.model.Ball;
import pacManReloaded.common.model.Ghost;
import pacManReloaded.common.model.INavigator;
import pacManReloaded.common.model.Map;
import pacManReloaded.common.model.PacMan;
import pacManReloaded.common.model.PowerBall;
import pacManReloaded.common.model.Wall;
import pacManReloaded.server.GameLoader;
import pacManReloaded.server.GameState;
import pacManReloaded.server.GameStatus;
import pacManReloaded.server.Player;
import pacManReloaded.server.PlayerState;
import pacManReloaded.server.Server;

public class GameLogic
implements INavigator {
    public GameState gameState;
    public Map map;
    public ArrayList<Player> players;
    private Server server;

    public GameLogic(ArrayList<Player> players, Server server) {
        try {
            this.map = new Map();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.players = players;
        this.server = server;
        this.gameState = new GameState(0, 0);
        this.loadMap("Map.txt");
        this.setGameStatus(GameStatus.playing);
        for (Player p : players) {
            p.sendInitPlayer(players);
            p.sendInitGameState(this.gameState);
            p.sendMap(this.map);
        }
    }

    public GameLogic() {
        this.gameState = new GameState(0, 0);
        try {
            this.map = new Map();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadMap(String path) {
        try {
            GameLoader loader = new GameLoader(this, this.players);
            loader.load(path, this.map, this.players);
            this.createBalls();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void nextMove() {
        this.checkSuperPower();
        for (Player actor : this.players) {
            actor.nextMove();
            actor.sendActorPosition(this.players);
            actor.sendGameState(this.gameState);
        }
        this.detectCollisions();
    }

    private List<Point2D> actorPosition() {
        ArrayList<Point2D> pos = new ArrayList<Point2D>();
        for (Player actor : this.players) {
            pos.add(actor.position);
        }
        return pos;
    }

    public void detectCollisions() {
        for (Player p : this.players) {
            Object o;
            if (p instanceof Ghost && this.gameState.superPower > 0) {
                o = this.getObjectAtPosition(p.position);
                if (o instanceof PowerBall) {
                    this.collisionWithPowerballGhost((PowerBall)o);
                } else if (o instanceof Ball) {
                    this.collisionWithBallGhost((Ball)o);
                }
            }
            if (p instanceof PacMan && this.gameState.superPower == 0) {
                o = this.getObjectAtPosition(p.position);
                if (o instanceof PowerBall) {
                    this.collisionWithPowerballPacMan((PowerBall)o);
                } else if (o instanceof Ball) {
                    this.collisionWithBallPacMan((Ball)o);
                }
            }
            this.detectActorsCollisions(p);
        }
    }

    private void detectActorsCollisions(Player p) {
        for (Player actor : this.players) {
            if (actor == p || !(actor instanceof Ghost) || !(p instanceof PacMan) || !this.intersect(p, actor)) continue;
            this.collisionWithGhost(p, actor);
        }
    }

    private void collisionWithGhost(Player p, Player actor) {
        if (this.gameState.superPower == 0) {
            this.gameState.scoreGhost += 50;
            p.setPosition(p.startPoint);
        } else {
            actor.position = actor.startPoint;
            this.gameState.scorePacMan += 50;
        }
    }

    private Point2D.Float findGhostPosition(List<Wall> spawn) {
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        for (Wall w : spawn) {
            for (int i = 0; i < w.points.size(); ++i) {
                points.add(w.points.get(i));
            }
        }
        float maxX = 0.0f;
        float maxY = 0.0f;
        float minX = ((Point2D.Float)points.get((int)0)).x;
        float minY = ((Point2D.Float)points.get((int)0)).y;
        for (Point2D.Float point : points) {
            if (point.getX() > (double)maxX) {
                maxX = (int)point.getX();
            }
            if (point.getY() > (double)maxY) {
                maxY = (int)point.getY();
            }
            if (point.getX() < (double)minX) {
                minX = (int)point.getX();
            }
            if (!(point.getY() < (double)minY)) continue;
            minY = (int)point.getY();
        }
        Random rand = new Random();
        float x = (float)rand.nextInt((int)(maxX - minX)) + minX;
        if (x == maxX) {
            x -= 1.0f;
        } else if (x == minX) {
            x += 1.0f;
        }
        float y = (float)rand.nextInt((int)(maxY - minY)) + minY;
        if (y == maxY) {
            y -= 1.0f;
        } else if (y == minY) {
            y += 1.0f;
        }
        Point2D.Float position = new Point2D.Float(x, y);
        return position;
    }

    private boolean intersect(Player p, Player actor) {
        Point2D.Float displayActorPos = this.map.Pos2DisplayPos(p.position);
        Rectangle2D.Double pRect = new Rectangle2D.Double(displayActorPos.getX() - 3.0, displayActorPos.getY() - 3.0, this.map.tSize - 6, this.map.tSize - 6);
        Point2D.Float displayPoint = this.map.Pos2DisplayPos(actor.position);
        Rectangle2D.Double actorRect = new Rectangle2D.Double(((Point2D)displayPoint).getX() - 3.0, ((Point2D)displayPoint).getY() - 3.0, this.map.tSize - 6, this.map.tSize - 6);
        return actorRect.intersects(pRect);
    }

    public void collisionWithPowerballPacMan(PowerBall o) {
        this.gameState.scorePacMan += 10;
        this.map.removePowerBall(o);
        this.gameState.superPower = 300;
        this.removeObject(o);
    }

    public void collisionWithPowerballGhost(PowerBall o) {
        this.gameState.scoreGhost += 10;
        this.map.removePowerBall(o);
        this.gameState.superPower = 300;
        this.removeObject(o);
    }

    public void removeObject(Ball o) {
        for (Player actor : this.players) {
            actor.sendRemoveObject(o);
        }
    }

    public void collisionWithBallPacMan(Ball o) {
        ++this.gameState.scorePacMan;
        this.map.removeBall(o);
        this.removeObject(o);
    }

    public void collisionWithBallGhost(Ball o) {
        ++this.gameState.scoreGhost;
        this.map.removeBall(o);
        this.removeObject(o);
    }

    public PacMan getPacman() {
        for (Player actor : this.players) {
            if (!(actor instanceof PacMan)) continue;
            return (PacMan)actor;
        }
        return null;
    }

    public void checkSuperPower() {
        if (this.gameState.superPower > 0) {
            --this.gameState.superPower;
            for (Player actor : this.players) {
                if (!(actor instanceof Ghost)) continue;
                ((Ghost)actor).setFear(true);
            }
        } else {
            for (Player actor : this.players) {
                if (!(actor instanceof Ghost)) continue;
                ((Ghost)actor).setFear(false);
            }
        }
    }

    private void createBalls() {
        float xStart = 0.0f;
        float yStart = 0.0f;
        for (Player actor : this.players) {
            if (!(actor instanceof PacMan)) continue;
            xStart = actor.position.x;
            yStart = actor.position.y;
            break;
        }
        this.findNextBall(xStart, yStart);
    }

    private void findNextBall(float xStart, float yStart) {
        Point2D.Float point;
        if (this.map.isFree(xStart + 1.0f, yStart)) {
            point = new Point2D.Float(xStart + 1.0f, yStart);
            this.createBall(point);
            this.findNextBall(xStart + 1.0f, yStart);
        }
        if (this.map.isFree(xStart - 1.0f, yStart)) {
            point = new Point2D.Float(xStart - 1.0f, yStart);
            this.createBall(point);
            this.findNextBall(xStart - 1.0f, yStart);
        }
        if (this.map.isFree(xStart, yStart - 1.0f)) {
            point = new Point2D.Float(xStart, yStart - 1.0f);
            this.createBall(point);
            this.findNextBall(xStart, yStart - 1.0f);
        }
        if (this.map.isFree(xStart, yStart + 1.0f)) {
            point = new Point2D.Float(xStart, yStart + 1.0f);
            this.createBall(point);
            this.findNextBall(xStart, yStart + 1.0f);
        }
    }

    public void createBall(Point2D.Float point) {
        Ball ball = new Ball(point);
        this.map.Balls.add(ball);
    }

    public synchronized void doPlay() {
        if (this.gameState.gameStatus == GameStatus.initialized) {
            this.doInitialized();
        }
        if (this.gameState.gameStatus == GameStatus.playing) {
            this.detectCollisions();
            this.nextMove();
        }
        if (this.gameState.gameStatus == GameStatus.sendingFinishInfo) {
            this.doSendFinishInfo();
        }
    }

    private void doSendFinishInfo() {
    }

    private void doInitialized() {
        for (int i = 0; i < this.players.size(); ++i) {
            Player p = this.players.get(i);
            p.setState(PlayerState.playing);
        }
    }

    public boolean isDone() {
        return this.gameState.gameStatus == GameStatus.done;
    }

    public GameStatus getGameStatus() {
        return this.gameState.gameStatus;
    }

    public void setGameStatus(GameStatus gameStatus) {
        this.gameState.gameStatus = gameStatus;
    }

    @Override
    public Object getObjectAtPosition(Point2D.Float position) {
        return this.map.getObject(position);
    }

    @Override
    public float getMapSize() {
        return this.map.getMapSize();
    }

    @Override
    public Point2D.Float getPacmanPosition() {
        return this.getPacman().position;
    }

    @Override
    public Point2D.Float getExitPosition() {
        return this.map.gate.position;
    }

    @Override
    public boolean isInSpawn(Ghost ghost) {
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        for (Wall w : this.map.Spawn) {
            for (int i = 0; i < w.points.size(); ++i) {
                points.add(w.points.get(i));
            }
        }
        float maxX = 0.0f;
        float maxY = 0.0f;
        float minX = ((Point2D.Float)points.get((int)0)).x;
        float minY = ((Point2D.Float)points.get((int)0)).y;
        for (Point2D.Float point : points) {
            if (point.getX() > (double)maxX) {
                maxX = (int)point.getX();
            }
            if (point.getY() > (double)maxY) {
                maxY = (int)point.getY();
            }
            if (point.getX() < (double)minX) {
                minX = (int)point.getX();
            }
            if (!(point.getY() < (double)minY)) continue;
            minY = (int)point.getY();
        }
        return ghost.position.getX() < (double)maxX && ghost.position.getX() > (double)minX && ghost.position.getY() < (double)maxY && ghost.position.getY() > (double)minY;
    }

    public GameState getGameState() {
        return this.gameState;
    }
}

