/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.server;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import pacManReloaded.common.LobbyState;
import pacManReloaded.common.messages.ChatWithAddress;
import pacManReloaded.common.messages.IMessage;
import pacManReloaded.common.model.Direction;
import pacManReloaded.common.model.Ghost;
import pacManReloaded.common.model.PacMan;
import pacManReloaded.server.GameLogic;
import pacManReloaded.server.GameStatus;
import pacManReloaded.server.Player;
import pacManReloaded.server.PlayerState;
import pacManReloaded.server.Server;
import pacManReloaded.server.ServerThread;

public class Lobby {
    private final int timerInterval = 100;
    private int gameInterval = 0;
    private LobbyState state;
    private String name;
    private ArrayList<Player> players = new ArrayList();
    private HashMap<Player, Integer> winner = new HashMap();
    private Timer timer;
    private Server server;
    private GameLogic gameLogic;
    private int counter;
    private long diff;
    private long now;
    private long last = 0L;
    private long avg;
    ArrayList<Long> messungen = new ArrayList();
    ArrayList<Long> averages = new ArrayList();
    private String messungenFileName = "messungen.txt";

    public Lobby(String name, Server server) {
        this.server = server;
        this.state = LobbyState.Open;
        this.name = name;
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Lobby.this.getServerTicks();
                if (Lobby.this.state == LobbyState.Playing) {
                    Lobby.this.checkGameStatus();
                }
                Lobby.this.checkLobbyStatus();
            }
        }, 100L, 100L);
    }

    private void checkGameStatus() {
        this.gameInterval += 100;
        if (this.gameInterval > 120000) {
            this.gameLogic.setGameStatus(GameStatus.done);
        }
    }

    private static boolean isInteger(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : !Character.isDigit(s.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private synchronized void checkLobbyStatus() {
        if (this.players.size() == 0) {
            this.state = LobbyState.Closed;
            this.gameLogic = null;
        } else if (this.state == LobbyState.Playing) {
            ArrayList toRemove = this.players.stream().filter(p -> p.getState() == PlayerState.done).collect(Collectors.toCollection(ArrayList::new));
            toRemove.forEach(p -> {
                p.gameFinished(false);
                this.players.remove(p);
            });
            if (this.players.size() == 1) {
                Player p2 = this.players.get(0);
                this.players.remove(0);
                this.state = LobbyState.Closed;
                this.gameLogic = null;
                p2.gameFinished(false);
            }
            if (this.gameLogic.getGameStatus() == GameStatus.done) {
                this.state = LobbyState.Closed;
                this.findWinner();
                this.gameLogic = null;
                this.players.forEach(p -> {
                    p.gameFinished(this.isWinner((Player)p));
                    if (this.isWinner((Player)p)) {
                        this.server.playerWon(p.getClient().getMyName(), this.winner.get(p));
                    }
                });
                this.players = new ArrayList();
            }
        } else if (this.state == LobbyState.Open && this.players.size() == 4) {
            this.state = LobbyState.Playing;
            this.gameLogic = new GameLogic(this.players, this.server);
        } else if (this.state == LobbyState.StartPlaying && this.players.size() < 4) {
            this.state = LobbyState.Open;
            this.players.get(0).sendBeginFailed();
        }
        if (this.gameLogic != null) {
            this.gameLogic.doPlay();
        }
    }

    private void findWinner() {
        if (this.gameLogic.getGameState().scorePacMan <= this.gameLogic.getGameState().scoreGhost) {
            for (Player pa : this.players) {
                if (!(pa instanceof Ghost)) continue;
                this.winner.put(pa, this.gameLogic.getGameState().scoreGhost);
            }
        } else {
            for (Player pa : this.players) {
                if (!(pa instanceof PacMan)) continue;
                this.winner.put(pa, this.gameLogic.getGameState().scorePacMan);
            }
        }
    }

    private boolean isWinner(Player p) {
        return this.winner.containsKey(p);
    }

    public String getName() {
        return this.name;
    }

    public LobbyState getState() {
        return this.state;
    }

    public void setState(LobbyState state) {
        this.state = state;
    }

    public synchronized boolean hasPlayer(String playerName) {
        for (Player player : this.players) {
            if (!player.getClient().getMyName().equals(playerName)) continue;
            return true;
        }
        return false;
    }

    public boolean addPlayer(ServerThread thread) {
        if (this.players.size() >= 4) {
            return false;
        }
        Player newPlayer = new Player(thread);
        this.players.add(newPlayer);
        return true;
    }

    public void removePlayer(ServerThread thread) {
        Player p = null;
        for (Player player : this.players) {
            if (player.getClient() != thread) continue;
            p = player;
            break;
        }
        if (p != null) {
            this.players.remove(p);
        }
    }

    public synchronized void handleMessage(IMessage gameMsg, ServerThread thread) {
        switch (gameMsg.getType()) {
            case BEGIN_GAME: {
                if (this.state != LobbyState.Open) break;
                this.state = LobbyState.StartPlaying;
                break;
            }
            case SEND_TO_ADDRESS: {
                this.handleBroadcastLobby((ChatWithAddress)gameMsg, thread);
            }
        }
    }

    private void handleBroadcastLobby(ChatWithAddress msg, ServerThread thread) {
        System.out.println("Lobby handle broadcast " + thread.getMyName());
        msg.setAddress(thread.getMyName());
        this.players.stream().forEach(p -> {
            if (p.getClient() != thread) {
                p.getClient().send(msg);
            }
        });
    }

    public void handleChangeDir(String changeDirMsg, ServerThread thread) {
        for (Player p : this.players) {
            if (p.getClient() != thread) continue;
            p.direction = Direction.valueOf(changeDirMsg);
        }
    }

    public ArrayList<Player> getPlayers() {
        return this.players;
    }

    public void getServerTicks() {
        if (this.counter == 0) {
            this.last = System.currentTimeMillis();
        }
        if (this.counter > 0 && this.counter < 101) {
            this.now = System.currentTimeMillis();
            this.diff = this.now - this.last;
            this.last = this.now;
            this.messungen.add(this.diff);
            System.out.println("Messung:" + this.diff);
        }
        if (this.counter == 101) {
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(this.messungenFileName));
                long sum = 0L;
                for (Long d : this.messungen) {
                    sum += d.longValue();
                }
                this.avg = sum / (long)this.messungen.size();
                System.out.println("Average:" + this.avg);
                this.averages.add(this.avg);
                for (Long a : this.averages) {
                    pw.println(a.toString());
                }
                pw.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("Cannot write Server-Ticks: " + e.getMessage());
            }
        }
        ++this.counter;
    }
}

