/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.server;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import pacManReloaded.common.Command;
import pacManReloaded.common.CommandFactory;
import pacManReloaded.common.messages.IMessage;
import pacManReloaded.common.model.Ball;
import pacManReloaded.common.model.Direction;
import pacManReloaded.common.model.Gate;
import pacManReloaded.common.model.Ghost;
import pacManReloaded.common.model.INavigator;
import pacManReloaded.common.model.Map;
import pacManReloaded.common.model.PacMan;
import pacManReloaded.common.model.PowerBall;
import pacManReloaded.common.model.Wall;
import pacManReloaded.server.GameState;
import pacManReloaded.server.PlayerState;
import pacManReloaded.server.ServerThread;

public class Player {
    public Direction direction;
    public Point2D.Float position;
    protected float speed;
    protected INavigator navigator;
    public Point2D.Float startPoint;
    private ServerThread client;
    private PlayerState state;
    private long msgSentTime;
    private int points;

    public Player(ServerThread client) {
        this.client = client;
    }

    public Player() {
    }

    public ServerThread getClient() {
        return this.client;
    }

    public PlayerState getState() {
        return this.state;
    }

    public void sendMap(Map map) {
        ArrayList<String> params = new ArrayList<String>();
        Object object = map.xSize + "," + map.ySize + "," + map.tSize + ";";
        params.add((String)object);
        object = "";
        for (Wall wall : map.Walls) {
            for (Point2D point2D : wall.points) {
                object = (String)object + point2D.getX() + "," + point2D.getY() + ";";
            }
            object = (String)object + "!";
        }
        params.add((String)object);
        object = "";
        for (Wall wall : map.Spawn) {
            for (Point2D point2D : wall.points) {
                object = (String)object + point2D.getX() + "," + point2D.getY() + ";";
            }
            object = (String)object + "!";
        }
        params.add((String)object);
        object = "";
        for (PowerBall powerBall : map.PowerBalls) {
            object = (String)object + powerBall.position.getX() + "," + powerBall.position.getY() + ";";
        }
        params.add((String)object);
        object = "";
        for (Ball ball : map.Balls) {
            object = (String)object + ball.position.getX() + "," + ball.position.getY() + ";";
        }
        params.add((String)object);
        object = map.gate.position.x + "," + map.gate.position.y + ";";
        params.add((String)object);
        IMessage mapMsg = CommandFactory.createMessage(Command.MAP, params);
        this.client.send(mapMsg);
    }

    public void sendInitPlayer(ArrayList<Player> players) {
        ArrayList<String> params = new ArrayList<String>();
        Object parm = "";
        for (Player p : players) {
            parm = (String)parm + p.client.getMyName();
            if (p instanceof PacMan) {
                parm = (String)parm + ",PacMan," + p.position.getX() + "," + p.position.getY() + ";";
                continue;
            }
            parm = (String)parm + ",Ghost," + ((Ghost)p).color + "," + p.position.getX() + "," + p.position.getY() + ";";
        }
        params.add((String)parm);
        IMessage initplayerMsg = CommandFactory.createMessage(Command.INIT_PLAYER, params);
        this.client.send(initplayerMsg);
    }

    public void sendInitGameState(GameState gameState) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.parmsGameState(gameState));
        IMessage gameStateMsg = CommandFactory.createMessage(Command.INIT_GAMESTATE, params);
        this.client.send(gameStateMsg);
    }

    public void sendRemoveObject(Ball o) {
        ArrayList<String> params = new ArrayList<String>();
        String parm = o.position.getX() + "," + o.position.getY();
        params.add(parm);
        IMessage gameStateMsg = CommandFactory.createMessage(Command.REMOVE_OBJECT, params);
        this.client.send(gameStateMsg);
    }

    public void sendGameState(GameState gameState) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.parmsGameState(gameState));
        IMessage gameStateMsg = CommandFactory.createMessage(Command.GAMESTATE, params);
        this.client.send(gameStateMsg);
    }

    private String parmsGameState(GameState gameState) {
        Object parm = "";
        parm = gameState.superPower + "," + gameState.scoreGhost + "," + gameState.scorePacMan;
        return parm;
    }

    public void sendActorPosition(ArrayList<Player> players) {
        ArrayList<String> params = new ArrayList<String>();
        Object parm = "";
        for (Player p : players) {
            parm = (String)parm + p.client.getMyName();
            parm = (String)parm + "," + p.direction + "," + p.position.getX() + "," + p.position.getY() + ";";
        }
        params.add((String)parm);
        IMessage actorPosMsg = CommandFactory.createMessage(Command.ACTOR_POSITION, params);
        this.client.send(actorPosMsg);
    }

    public void setState(PlayerState state) {
        this.state = state;
    }

    public long getMsgSentTime() {
        return this.msgSentTime;
    }

    public void sendBeginFailed() {
        IMessage beginFailedMsg = CommandFactory.createMessage(Command.BEGIN_FAILED, null);
        this.client.send(beginFailedMsg);
    }

    public void gameFinished(boolean gameResult) {
        ArrayList<String> params = new ArrayList<String>();
        if (gameResult) {
            params.add("WON");
        } else {
            params.add("LOSE");
        }
        params.add("");
        IMessage msg = CommandFactory.createMessage(Command.GAME_FINISHED, params);
        this.client.send(msg);
        this.msgSentTime = System.currentTimeMillis();
    }

    protected void changePosition() {
        switch (this.direction) {
            case right: {
                Object o = this.navigator.getObjectAtPosition(new Point2D.Float(this.position.x + this.speed, this.position.y));
                if (o instanceof Wall) break;
                this.position = new Point2D.Float(this.position.x + this.speed, this.position.y);
                if (this.position.x > this.navigator.getMapSize() - 1.0f) {
                    this.position.x = 0.0f;
                    break;
                }
                if (!(this.position.x < 0.0f)) break;
                this.position.x = this.navigator.getMapSize() - 1.0f;
                break;
            }
            case left: {
                Object o = this.navigator.getObjectAtPosition(new Point2D.Float(this.position.x - this.speed, this.position.y));
                if (o instanceof Wall || o instanceof Gate) break;
                this.position = new Point2D.Float(this.position.x - this.speed, this.position.y);
                if (this.position.x > this.navigator.getMapSize() - 1.0f) {
                    this.position.x = 0.0f;
                    break;
                }
                if (!(this.position.x < 0.0f)) break;
                this.position.x = this.navigator.getMapSize() - 1.0f;
                break;
            }
            case up: {
                Object o = this.navigator.getObjectAtPosition(new Point2D.Float(this.position.x, this.position.y - this.speed));
                if (o instanceof Wall || o instanceof Gate) break;
                this.position = new Point2D.Float(this.position.x, this.position.y - this.speed);
                if (this.position.x > this.navigator.getMapSize() - 1.0f) {
                    this.position.x = 0.0f;
                    break;
                }
                if (!(this.position.x < 0.0f)) break;
                this.position.x = this.navigator.getMapSize() - 1.0f;
                break;
            }
            case down: {
                Object o = this.navigator.getObjectAtPosition(new Point2D.Float(this.position.x, this.position.y + this.speed));
                if (o instanceof Wall || o instanceof Gate) break;
                this.position = new Point2D.Float(this.position.x, this.position.y + this.speed);
                if (this.position.x > this.navigator.getMapSize() - 1.0f) {
                    this.position.x = 0.0f;
                    break;
                }
                if (!(this.position.x < 0.0f)) break;
                this.position.x = this.navigator.getMapSize() - 1.0f;
                break;
            }
        }
    }

    public void nextMove() {
    }

    public void setStartPoint(Point2D.Float point) {
        this.startPoint = point;
    }

    public void setPosition(Point2D.Float point) {
        this.position = point;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }
}

