/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.server;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import pacManReloaded.common.Command;
import pacManReloaded.common.CommandFactory;
import pacManReloaded.common.JoinLobbyResult;
import pacManReloaded.common.LobbyState;
import pacManReloaded.common.messages.ChatMessage;
import pacManReloaded.common.messages.ChatWithAddress;
import pacManReloaded.common.messages.IMessage;
import pacManReloaded.server.HighScore;
import pacManReloaded.server.Lobby;
import pacManReloaded.server.Player;
import pacManReloaded.server.ServerThread;

public class Server
implements Runnable {
    private ArrayList<ServerThread> clients = new ArrayList();
    private ArrayList<Lobby> lobbies = new ArrayList();
    private ServerSocket server;
    private Thread thread = null;
    private Timer timer;
    private final int pingInterval = 5000;
    private String highScoreFileName = "hs.txt";
    private ArrayList<HighScore> highScores;
    private String manualFileName = "manual.txt";
    private String manualText = "";

    public Server(int port) {
        InetAddress iP = null;
        try {
            iP = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        Path currentRelativePath = Paths.get("", new String[0]);
        String s = currentRelativePath.toAbsolutePath().toString();
        System.out.println("Current relative path is: " + s);
        System.out.println("Your IP-Address is: " + iP.getHostAddress());
        try {
            System.out.println("Binding to port " + port + ", please wait  ...");
            this.server = new ServerSocket(port);
            this.loadHighScores();
            this.loadManual();
            System.out.println("Server started: " + this.server);
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            System.exit(1);
        }
        this.start();
    }

    private void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (Server.this.clients.size() > 0) {
                        Server.this.checkPingPong();
                    }
                }
            }, 5000L, 5000L);
            this.thread.start();
        }
    }

    @Override
    public void run() {
        try {
            while (this.thread != null) {
                System.out.println("Waiting for a client");
                this.addThread(this.server.accept());
            }
            try {
                this.server.close();
                for (ServerThread serverThread : this.clients) {
                    try {
                        serverThread.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException e212) {
                System.out.println("Error occured during closing the Server! (IOException)");
            }
        }
        catch (IOException e1) {
            System.out.println("connection failed");
        }
    }

    public synchronized void remove(ServerThread threadToTerminate) {
        if (!this.clients.contains(threadToTerminate)) {
            return;
        }
        System.out.println("Removing client thread " + threadToTerminate.getThreadId());
        if (threadToTerminate.getSocket() != null) {
            IMessage closeMsg = CommandFactory.createMessage(Command.CLOSE, null);
            threadToTerminate.send(closeMsg);
        }
        this.clients.remove(threadToTerminate);
        for (Lobby lobby : this.lobbies) {
            lobby.removePlayer(threadToTerminate);
        }
        System.out.println("Client thread " + threadToTerminate.getThreadId() + " removed");
        try {
            threadToTerminate.close();
        }
        catch (IOException ioe) {
            System.out.println("Error closing thread: " + ioe);
        }
    }

    private synchronized void checkPingPong() {
        ArrayList<ServerThread> toRemove = new ArrayList<ServerThread>();
        long now = System.currentTimeMillis();
        System.out.println("Ping-pong check..." + this.toReadableTime(now));
        IMessage pingMsg = CommandFactory.createMessage(Command.PING, null);
        for (ServerThread client : this.clients) {
            if (now - client.getLastContact() > 20000L) {
                toRemove.add(client);
                System.out.println("Client to remove: " + client.getMyName() + "last time: " + this.toReadableTime(client.getLastContact()));
                continue;
            }
            if (now - client.getLastContact() <= 5000L) continue;
            client.send(pingMsg);
            System.out.println("Ping sent to client " + client.getMyName() + " at " + this.toReadableTime(now));
        }
        for (ServerThread client : toRemove) {
            this.remove(client);
        }
    }

    private String toReadableTime(long timeInms) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date resultDate = new Date(timeInms);
        return sdf.format(resultDate);
    }

    private void addThread(Socket socket) {
        ServerThread st = new ServerThread(this, socket);
        this.clients.add(st);
        System.out.println("Client accepted: " + socket + ". Connected " + this.clients.size() + " clients");
        try {
            st.open();
            st.start();
        }
        catch (IOException ioe) {
            System.out.println("Error opening thread: " + ioe);
            this.clients.remove(st);
        }
    }

    public synchronized String getAndSetName(ServerThread thread, String myName, String suffix) {
        Object newName = myName + suffix;
        if (((String)(newName = ((String)newName).replace("|", ""))).length() == 0) {
            newName = "ABC";
        }
        Object checkName = newName;
        if (this.clients.size() > 1 && this.clients.stream().anyMatch(arg_0 -> Server.lambda$getAndSetName$0((String)checkName, arg_0))) {
            String newSuffix = suffix.length() == 0 ? "2" : String.valueOf(Integer.parseInt(suffix) + 1);
            newName = this.getAndSetName(thread, myName, newSuffix);
            thread.setMyName((String)newName);
        }
        if (suffix.length() == 0) {
            thread.setMyName((String)newName);
        }
        return newName;
    }

    public String getHighScoreString() {
        Object result = "High Score:||";
        for (HighScore h : this.highScores) {
            result = (String)result + "Client Name: " + h.getName() + "; \t Number: " + h.getNumber() + "; \t HighScore: " + h.getHighScore() + ";|";
        }
        return result;
    }

    public String getLobbyInfoString() {
        Object result = "Lobbies: |";
        for (Lobby l : this.lobbies) {
            result = (String)result + "  Lobby Name: " + l.getName() + ";  Status: " + l.getState() + ";|";
            result = (String)result + "    Users:|";
            for (Player p : l.getPlayers()) {
                result = (String)result + "      Username: " + p.getClient().getMyName() + ";  State: " + p.getState() + ";|";
            }
            result = (String)result + "|";
        }
        return result;
    }

    public String getClientInfoString() {
        Object result = "Connected users: |";
        for (ServerThread st : this.clients) {
            result = (String)result + "   " + st.getMyName() + "|";
        }
        return result;
    }

    private void loadManual() throws IOException {
        String line;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.manualFileName);
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        while ((line = in.readLine()) != null) {
            this.manualText = this.manualText + line + System.lineSeparator();
        }
        in.close();
    }

    private void loadHighScores() {
        this.highScores = new ArrayList();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.highScoreFileName);
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String line = in.readLine();
            while (line != null) {
                String[] splitted = line.split("\\|");
                HighScore hs = new HighScore(splitted[0], Integer.parseInt(splitted[1]), Integer.parseInt(splitted[2]));
                this.highScores.add(hs);
                line = in.readLine();
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println("Cannot load high scores: " + e.getMessage());
        }
    }

    private void saveHighScores() {
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(this.highScoreFileName));
            for (HighScore hs : this.highScores) {
                pw.println(hs.toString());
            }
            pw.close();
        }
        catch (Exception e) {
            System.out.println("Cannot save high scores: " + e.getMessage());
        }
    }

    public String getManualText() {
        String result = this.manualText.replace(System.lineSeparator(), "|");
        return result;
    }

    public void broadcast(ServerThread thread, ChatMessage chatMessage) {
        chatMessage.setFrom(thread.getMyName());
        System.out.println("Broadcasting info from " + thread.getMyName());
        for (ServerThread client : this.clients) {
            if (client == thread) continue;
            client.send(chatMessage);
            System.out.println("Chat sent to " + client.getMyName());
        }
    }

    public synchronized void handleChatWithAddress(ServerThread thread, ChatWithAddress msg) {
        Optional<ServerThread> optionalCl;
        System.out.println("Forward chat message from " + thread.getMyName());
        String address = msg.getAddress();
        if (address.equals("NotInLobby")) {
            msg.setAddress(thread.getMyName());
            ArrayList<ServerThread> clientsIsInLobby = new ArrayList<ServerThread>();
            for (ServerThread c2 : this.clients) {
                for (Lobby l2 : this.lobbies) {
                    if (!l2.hasPlayer(c2.getMyName())) continue;
                    clientsIsInLobby.add(c2);
                }
                if (clientsIsInLobby.contains(c2) || c2 == thread) continue;
                c2.send(msg);
            }
        } else {
            Optional<Lobby> optionalLobby = this.lobbies.stream().filter(l -> l.getName().equals(address) && l.hasPlayer(thread.getMyName())).findFirst();
            if (optionalLobby.isPresent()) {
                Lobby lo = optionalLobby.get();
                lo.handleMessage(msg, thread);
                System.out.println("Chat broadcasted in lobby" + thread.getMyName());
                return;
            }
        }
        if ((optionalCl = this.clients.stream().filter(c -> c.getMyName().equals(address)).findFirst()).isPresent()) {
            ServerThread cl = optionalCl.get();
            msg.setAddress(thread.getMyName());
            cl.send(msg);
            System.out.println("Whisper chat to " + cl.getMyName());
            return;
        }
        System.out.println("Client " + address + " not found!");
    }

    public String getToReadableTime(long timeInms) {
        return this.toReadableTime(timeInms);
    }

    public synchronized JoinLobbyResult joinLobby(ServerThread thread, String lobbyName) {
        lobbyName = lobbyName.replace('|', '_');
        Lobby shouldJoin = null;
        for (Lobby lobby : this.lobbies) {
            if (lobby.hasPlayer(thread.getMyName())) {
                return JoinLobbyResult.AlreadyPlaying;
            }
            if (!lobby.getName().equalsIgnoreCase(lobbyName)) continue;
            if (lobby.getState() != LobbyState.Open) {
                return JoinLobbyResult.Rejected;
            }
            shouldJoin = lobby;
        }
        if (shouldJoin != null) {
            if (shouldJoin.addPlayer(thread)) {
                return JoinLobbyResult.Joined;
            }
            return JoinLobbyResult.Rejected;
        }
        Lobby newLobby = new Lobby(lobbyName, this);
        if (!newLobby.addPlayer(thread)) {
            return JoinLobbyResult.Rejected;
        }
        this.lobbies.add(newLobby);
        return JoinLobbyResult.Created;
    }

    public Lobby findLobby(ServerThread thread) {
        for (Lobby lobby : this.lobbies) {
            if (!lobby.hasPlayer(thread.getMyName())) continue;
            return lobby;
        }
        return null;
    }

    public void playerWon(String playerName, int score) {
        for (HighScore highScore : this.highScores) {
            if (!highScore.getName().equalsIgnoreCase(playerName)) continue;
            highScore.setNumber(highScore.getNumber() + 1);
            if (highScore.getHighScore() < score) {
                highScore.setHighScore(score);
            }
            this.saveHighScores();
            return;
        }
        this.highScores.add(new HighScore(playerName, 1, score));
        this.saveHighScores();
    }

    private static /* synthetic */ boolean lambda$getAndSetName$0(String checkName, ServerThread c) {
        return c.getMyName() != null && c.getMyName().equals(checkName);
    }
}

