/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.server;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import pacManReloaded.common.Command;
import pacManReloaded.common.CommandFactory;
import pacManReloaded.common.JoinLobbyResult;
import pacManReloaded.common.messages.ChatMessage;
import pacManReloaded.common.messages.ChatWithAddress;
import pacManReloaded.common.messages.IMessage;
import pacManReloaded.common.messages.NoParameterMessage;
import pacManReloaded.common.messages.SingleStringParameterMessage;
import pacManReloaded.server.Lobby;
import pacManReloaded.server.ServerThread;

public class ServerProtocol {
    public void onInit(ServerThread st) {
        st.send(CommandFactory.createMessage(Command.GET_NICKNAME, null));
    }

    private String toReadableTime(long timeInms) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date resultDate = new Date(timeInms);
        return sdf.format(resultDate);
    }

    public void handleMsg(ServerThread thread, IMessage gameMsg) throws IOException {
        System.out.println("Server " + thread.getThreadId() + " received: " + gameMsg);
        switch (gameMsg.getType()) {
            case MY_NICKNAME: {
                SingleStringParameterMessage myNameMessage = (SingleStringParameterMessage)gameMsg;
                String acceptedName = thread.getServer().getAndSetName(thread, myNameMessage.getParamValue(), "");
                ArrayList<String> params = new ArrayList<String>();
                params.add(acceptedName);
                IMessage response = CommandFactory.createMessage(Command.SET_NICKNAME, params);
                thread.send(response);
                break;
            }
            case MESSAGE: {
                ChatMessage chatMessage = (ChatMessage)gameMsg;
                thread.getServer().broadcast(thread, chatMessage);
                break;
            }
            case SEND_TO_ADDRESS: {
                ChatWithAddress chatMsg = (ChatWithAddress)gameMsg;
                thread.getServer().handleChatWithAddress(thread, chatMsg);
                break;
            }
            case JOIN_LOBBY: {
                SingleStringParameterMessage joinLobbyMsg = (SingleStringParameterMessage)gameMsg;
                JoinLobbyResult lobby = thread.getServer().joinLobby(thread, joinLobbyMsg.getParamValue());
                ArrayList<String> params = new ArrayList<String>();
                params.add(lobby.toString());
                IMessage response = CommandFactory.createMessage(Command.JOIN_LOBBY_RESPONSE, params);
                thread.send(response);
                break;
            }
            case CHANGE_DIRECTION: {
                SingleStringParameterMessage changeDirMsg = (SingleStringParameterMessage)gameMsg;
                Lobby lo = thread.getServer().findLobby(thread);
                if (lo != null) {
                    lo.handleChangeDir(changeDirMsg.getParamValue(), thread);
                    break;
                }
                System.out.println("No lobby found for " + thread.getMyName());
                break;
            }
            case GET_LOBBY_INFO: {
                String serverInfo = thread.getServer().getLobbyInfoString();
                ArrayList<String> params = new ArrayList<String>();
                params.add(serverInfo);
                IMessage response = CommandFactory.createMessage(Command.LOBBY_INFO, params);
                thread.send(response);
                break;
            }
            case GET_CLIENT_INFO: {
                String serverInfo = thread.getServer().getClientInfoString();
                ArrayList<String> params = new ArrayList<String>();
                params.add(serverInfo);
                IMessage response = CommandFactory.createMessage(Command.CLIENT_INFO, params);
                thread.send(response);
                break;
            }
            case GET_HIGHSCORE: {
                String serverInfo = thread.getServer().getHighScoreString();
                ArrayList<String> params = new ArrayList<String>();
                params.add(serverInfo);
                IMessage response = CommandFactory.createMessage(Command.HIGHSCORE, params);
                thread.send(response);
                break;
            }
            case GET_MANUAL: {
                String serverInfo = thread.getServer().getManualText();
                ArrayList<String> params = new ArrayList<String>();
                params.add(serverInfo);
                IMessage response = CommandFactory.createMessage(Command.MANUAL, params);
                thread.send(response);
                break;
            }
            case BEGIN_GAME: {
                Lobby l = thread.getServer().findLobby(thread);
                if (l != null) {
                    l.handleMessage(gameMsg, thread);
                    break;
                }
                System.out.println("No lobby found for " + thread.getMyName());
                break;
            }
            case PING: {
                NoParameterMessage pongMsg = new NoParameterMessage(Command.PONG);
                thread.send(pongMsg);
                System.out.println("Pong sent as answer at: " + this.toReadableTime(System.currentTimeMillis()));
                break;
            }
            case PONG: {
                thread.updateLastContact();
                System.out.println("Server received a Pong from " + thread.getMyName() + " at " + this.toReadableTime(System.currentTimeMillis()));
                break;
            }
            case UNKNOWN_MESSAGE: {
                System.out.println("This command is not defined: " + gameMsg + " and therefore will be ignored.");
                break;
            }
            default: {
                System.out.println("We should not be here! " + gameMsg);
            }
        }
    }
}

