/*
 * Decompiled with CFR 0.152.
 */
package pacManReloaded.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import pacManReloaded.common.CommandFactory;
import pacManReloaded.common.messages.IMessage;
import pacManReloaded.server.Server;
import pacManReloaded.server.ServerProtocol;

public class ServerThread
extends Thread {
    private Socket socket;
    private int id;
    private BufferedReader streamIn = null;
    private BufferedWriter streamOut = null;
    private ServerProtocol protocol = new ServerProtocol();
    private Server server;
    private String myName;
    private long lastContact;

    public ServerThread(Server serverx, Socket socketx) {
        this.server = serverx;
        this.socket = socketx;
        this.id = this.socket.getPort();
        this.lastContact = System.currentTimeMillis();
    }

    @Override
    public void run() {
        System.out.println("Server Thread " + this.id + " waiting for messages...");
        this.protocol.onInit(this);
        try {
            String msg;
            while ((msg = this.streamIn.readLine()) != null) {
                IMessage gameMsg = CommandFactory.parseMessage(msg);
                this.protocol.handleMsg(this, gameMsg);
            }
        }
        catch (IOException ioe) {
            System.out.println(this.id + " : " + ioe.getMessage());
        }
        try {
            this.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(this.id + " : removed!");
        this.server.remove(this);
    }

    public void open() throws IOException {
        this.streamIn = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "utf-8"));
        this.streamOut = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "utf-8"));
    }

    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        if (this.streamIn != null) {
            this.streamIn.close();
            this.streamIn = null;
        }
        if (this.streamOut != null) {
            this.streamOut.close();
            this.streamOut = null;
        }
        this.server.remove(this);
    }

    public void send(IMessage msg) {
        try {
            this.streamOut.write(msg + System.lineSeparator());
            this.streamOut.flush();
        }
        catch (IOException ioe) {
            System.out.println(this.id + " ERROR sending: " + ioe.getMessage());
            this.server.remove(this);
        }
    }

    private String toReadableTime(long timeInms) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date resultDate = new Date(timeInms);
        return sdf.format(resultDate);
    }

    public Server getServer() {
        return this.server;
    }

    public int getThreadId() {
        return this.id;
    }

    public String getMyName() {
        return this.myName;
    }

    public void setMyName(String myName) {
        this.myName = myName;
    }

    public long getLastContact() {
        return this.lastContact;
    }

    public void updateLastContact() {
        this.lastContact = System.currentTimeMillis();
    }

    public Socket getSocket() {
        return this.socket;
    }
}

