package pacManReloaded.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class InformationGUI extends JFrame {

  private JPanel contentPane;
  private static JTextArea textArea;

  /**
   * sets the visibility if the information GUI
   *
   * @param infoText the info text as string
   * @param size the size of the infotext
   * @param title the title of the infotext
   */
  public static void initInformationGUI(String infoText, Dimension size, String title) {
    InformationGUI frame = new InformationGUI();
    frame.setTitle(title);
    frame.setVisible(true);
    frame.setSize(size);
    handleInfoText(infoText);
  }

  /**
   * handles the text of the info
   *
   * @param infoText the info as string
   */
  private static void handleInfoText(String infoText) {
    textArea.setText(infoText);
  }

  /**
   * Constructor of the Class, creates the frame.
   */
  public InformationGUI() {
    Font f = new Font("Arial", Font.TRUETYPE_FONT, 13);
    Color yellow = new Color(253, 240, 0);
    Color blue = new Color(63, 72, 203);

    setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
    setBounds(100, 100, 450, 300);
    contentPane = new JPanel();
    contentPane.setBorder(BorderFactory.createLineBorder(blue));
    contentPane.setBackground(Color.BLACK);
    setContentPane(contentPane);
    contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.X_AXIS));

    JScrollPane scrollPane = new JScrollPane();
    scrollPane.setBorder(BorderFactory.createLineBorder(blue));
    scrollPane.setBackground(Color.BLACK);
    contentPane.add(scrollPane);

    textArea = new JTextArea();
    textArea.setFont(f);
    textArea.setBackground(Color.black);
    textArea.setBorder(BorderFactory.createLineBorder(blue));
    textArea.setDisabledTextColor(yellow);
    textArea.setEnabled(false);
    scrollPane.setViewportView(textArea);
  }

}
