package pacManReloaded.common;

/**
 * Commands that can be used by Server and Client
 */
public enum Command {

  /**
   * Broadcast messages to all clients in the Lobby.
   */
  MESSAGE("#message"),

  /**
   * Parameters: Username of receiver and messages separated by :. Redirect the messages to the
   * specific client.
   */
  SEND_TO_ADDRESS("#sendTO"),

  /**
   * close command
   */
  CLOSE("#close"),

  /**
   * Highscore command
   */
  HIGHSCORE("#hScore"),

  /**
   * highscore request command
   */
  GET_HIGHSCORE("#getHScore"),

  /**
   * Lobby info request command
   */
  GET_LOBBY_INFO("#getLInfo"),

  /**
   * lobby info command
   */
  LOBBY_INFO("#LInfo"),

  /**
   * map command
   */
  MAP("#Map"),

  /**
   * Client Info request command
   */
  GET_CLIENT_INFO("#getCInfo"),

  /**
   * client info command
   */
  CLIENT_INFO("#CInfo"),

  /**
   * manual request command
   */
  GET_MANUAL("#getManu"),

  /**
   * manual command
   */
  MANUAL("#ManualGUI"),

  /**
   * Sent to check connection. pong sent if check successful.
   */
  PING("#ping"),

  /**
   * Connection check successful.
   */
  PONG("#pong"),

  /**
   * gets the Nickname of Client or Server.
   */

  GET_NICKNAME("#getName"),

  /**
   * The Nickname of the Sender will be send.
   */
  MY_NICKNAME("#myName"),

  /**
   * The Nickname will be changed.
   */
  SET_NICKNAME("#setName"),

  /**
   * if the protocol messages has not one of the mentioned prefixes from above, the prefix
   * UNKNOWN_MESSAGE is returned.
   */
  UNKNOWN_MESSAGE("#UNKN_MSG"),

  /**
   * beginnt failed command
   */
  BEGIN_FAILED("#BegFail"),

  /**
   * join lobby request command
   */
  JOIN_LOBBY("#join@lby"),

  /**
   * join lobby response command
   */
  JOIN_LOBBY_RESPONSE("#lbyRespo"),

  ACTOR_POSITION("#actrPos"),

  /**
   * begin game request command
   */
  BEGIN_GAME("#begGame"),

  INIT_PLAYER("#initPly"),

  GAMESTATE("#gState"),

  INIT_GAMESTATE("#initGSte"),

  CHANGE_DIRECTION("#chgeDir"),

  REMOVE_OBJECT("#remvObj"),

  /**
   * game finished command
   */
  GAME_FINISHED("#gameFinish");


  private String txt;

  /**
   * Constructor of this class.  Sets the private field txt to the parameter.
   *
   * @param txt string represents an enum field.
   */
  Command(String txt) {
    this.txt = txt;
  }

  /**
   * "getter" for the Command-enum
   *
   * @param value the enum as string
   * @return the resulting enum
   */
  public static Command getEnum(String value) {
    for (Command v : values()) {
      if (v.txt.equals(value)) {
        return v;
      }
    }
    throw new IllegalArgumentException();
  }

  /* (non-Javadoc)
   * @see java.lang.Enum#toString()
   */
  @Override
  public String toString() {
    return txt;
  }
}