package pacManReloaded.common;

import pacManReloaded.client.Client;
import pacManReloaded.server.Server;

public class Main {

  /**
   * main method, 2cases:1. create server; 2. create client
   *
   * @param args client hostadress: port(username) | server port
   */
  public static void main(String args[]) {
    if (args.length > 0) {
      handleArgs(args);
    } else {
      System.out.println("Not enough args.");
    }
  }

  /**
   * handling the args, decides if it creates a server or client, depending on args
   *
   * @param args client 1: hostadress: port (username), 2: server port
   */
  private static void handleArgs(String[] args) {
    if (args[0].equals("server")) {
      createServer(args);
    } else if (args[0].equals("client")) {
      createClient(args);
    } else {
      System.err
          .println("Expected Arguments:\nclient <hostadress>: <port> (<username>) | server <port>");
      System.exit(1);
    }
  }

  /**
   * creates client with name
   *
   * @param args hostadress: port username
   */
  private static void createClient(String[] args) {
    switch (args.length) {
      case 2: {
        createClient(args, "");
        break;
      }
      case 3: {
        createClient(args, args[2]);
        break;
      }
      default: {
        System.err.println(
            "Expected Arguments:\nclient <hostadress>: <port> (<username>) | server <port>");
        System.exit(1);
      }
    }
  }

  /**
   * creates a server with the inputted port
   *
   * @param args port
   */
  private static void createServer(String[] args) {
    int port = 0;
    try {
      port = Integer.parseInt(args[1]);
    } catch (NumberFormatException e232) {
      System.err.println("invalid Port.");
      System.exit(1);
    }
    if (1023 < port && port < 49152) {
    } else {
      System.err.println("invalid portnumber");
      System.exit(1);
    }
    Server server = new Server(port);
  }

  /**
   * creates a client with name
   *
   * @param args hostadress: port
   * @param name name of the creating client
   */
  private static void createClient(String[] args, String name) {
    try {
      String[] address = args[1].split(":");
      String ipAddress = address[0];
      int port = Integer.parseInt(address[1]);
      if (1023 < port && port < 49152) {
        Client client = new Client(name, ipAddress, port);
      } else {
        System.err.println("invalid portnumber");
        System.exit(1);
      }
    } catch (NumberFormatException e434) {
      System.err.println("invalid portnumber");
      System.exit(1);
    }
  }

}
