package pacManReloaded.common.messages;

import static pacManReloaded.common.Command.MESSAGE;

import pacManReloaded.common.Command;


public class ChatMessage implements IMessage {

  private final String info;
  private final Command commandType = MESSAGE;
  private String from;

  /**
   * Constructor of the class
   *
   * @param buffer string which splits
   */
  public ChatMessage(String buffer) {
    int index = buffer.indexOf(IMessage.separator);
    this.from = (index > 0) ? buffer.substring(0, index) : buffer;
    this.info = buffer.length() > index ? buffer.substring(index + 1) : "";
  }

  /**
   * Constructor of the class
   *
   * @param from where the message comes from
   * @param info info of the message
   */
  public ChatMessage(String from, String info) {
    this.from = from;
    this.info = info;
  }

  /**
   * "getter" for the info of the message
   *
   * @return info of the message
   */
  public String getInfo() {
    return info;
  }

  /**
   * "getter" for where the message comes from
   *
   * @return where the messages come from
   */
  public String getFrom() {
    return from;
  }

  /**
   * "setter" for where the message comes from
   *
   * @param from where the message comes from
   */
  public void setFrom(String from) {
    this.from = from;
  }

  /**
   * the to String method, forms the message into a string, seperated by "|"
   *
   * @return string which contains the command type, the sender and the message info seperated by a
   * "|"
   */
  public String toString() {
    return commandType.toString() + IMessage.separator + from + IMessage.separator + info;
  }

  /**
   * "getter" for the type of the command
   *
   * @return type of the command
   */
  public Command getType() {
    return this.commandType;
  }
}