package pacManReloaded.common.messages;

import pacManReloaded.common.Command;

public class ChatWithAddress implements IMessage {

  private final String info;
  private final Command cmdType = Command.SEND_TO_ADDRESS;
  private String address; // can be user or lobby

  /**
   * Constructor of the class
   *
   * @param to - where the message will be send to
   * @param info - info of the message
   */
  public ChatWithAddress(String to, String info) {
    this.info = info;
    this.address = to;
  }

  /**
   * Constructor of the class, splits the string in an array
   *
   * @param buffer - string which splits
   */
  public ChatWithAddress(String buffer) {
    String[] splitted = buffer.split("\\|");
    this.address = splitted[0];
    this.info = splitted[1];
  }

  /**
   * "getter" for the address
   *
   * @return - the adress
   */
  public String getAddress() {
    return address;
  }

  /**
   * "setter" for the address
   *
   * @param fromOrTo address of the client who sends or gets the message
   */
  public void setAddress(String fromOrTo) {
    this.address = fromOrTo;
  }

  /**
   * "getter" for the info of the message
   *
   * @return - the info of the message
   */
  public String getInfo() {
    return info;
  }

  /**
   * the to String method, forms the message into a string, seperated by "|"
   *
   * @return string which contains the command type, the address and the message info seperated by a
   * "|"
   */
  public String toString() {
    return cmdType.toString() + IMessage.separator + this.address + IMessage.separator + info;
  }

  /**
   * "getter" for the type of the command
   *
   * @return the type of the command
   */
  public Command getType() {
    return this.cmdType;
  }
}
