package pacManReloaded.common.messages;

import static pacManReloaded.common.Command.GAME_FINISHED;

import pacManReloaded.common.Command;

public class GameFinishedMessage implements IMessage {

  private final Command commandType = GAME_FINISHED;
  private final String answer;
  private final String balance;

  /**
   * Constructor of the class, splits the given string in an array
   *
   * @param buffer string which splits
   */
  public GameFinishedMessage(String buffer) {
    String[] splitted = buffer.split("\\|");
    this.answer = (splitted.length > 0) ? splitted[0] : null;
    this.balance = (splitted.length > 1) ? splitted[1] : "0";
  }

  /**
   * Constructor of the class
   *
   * @param answer answer of the question
   * @param balance balance(/money) of the player
   */
  public GameFinishedMessage(String answer, String balance) {
    this.answer = answer;
    this.balance = balance;
  }

  /**
   * the to String method, forms the message into a string, seperated by "|"
   *
   * @return string which contains the command type, the answer and the balance of the player
   * seperated by a "|"
   */
  public String toString() {
    return commandType.toString() + IMessage.separator + answer + IMessage.separator + balance;
  }

  /**
   * "getter" for type of the command
   *
   * @return type of the command
   */
  public Command getType() {
    return this.commandType;
  }

  /**
   * "getter" for the balance
   *
   * @return balance
   */
  public String getBalance() {
    return balance;
  }

  /**
   * "getter" for the answer
   *
   * @return answer
   */
  public String getAnswer() {
    return answer;
  }

}

