package pacManReloaded.common.messages;

import pacManReloaded.common.Command;

public class MapMessage implements IMessage {

  private final String walls;
  private final String spawn;
  private final String powerballs;
  private final String balls;
  private final String size;
  private final String gate;


  private Command commandType;

  /**
   * Constructor of the class
   *
   * @param commandType type of the command
   */
  public MapMessage(Command commandType, String size, String walls, String spawn, String powerballs,
      String balls, String gate) {
    this.commandType = commandType;
    this.size = size;
    this.walls = walls;
    this.spawn = spawn;
    this.powerballs = powerballs;
    this.balls = balls;
    this.gate = gate;
  }

  /**
   * "getter" for the value of the parameters
   *
   * @return walls
   */
  public String getParamValueWalls() {
    return walls;
  }

  /**
   * "getter" for the value of the parameters
   *
   * @return gate
   */
  public String getParamValueGate() {
    return gate;
  }

  /**
   * "getter" for the value of the parameters
   *
   * @return spawn
   */
  public String getParamValueSpawn() {
    return spawn;
  }

  /**
   * "getter" for the value of the parameters
   *
   * @return powerballs
   */
  public String getParamValuePowerBalls() {
    return powerballs;
  }

  /**
   * size of the parameter
   *
   * @return the size of the parameter
   */
  public String getParamValueSize() {
    return size;
  }

  /**
   * "getter" for the value of the parameters
   *
   * @return balls
   */
  public String getParamValueBalls() {
    return balls;
  }

  /**
   * "getter" for the type of the command
   *
   * @return type of the command
   */
  public Command getType() {
    return this.commandType;
  }

  /**
   * the to String method, forms the message into a string, seperated by "|"
   *
   * @return string which contains the command type and the parameter Value seperated by a "|"
   */
  public String toString() {
    return commandType.toString() + IMessage.separator + size + IMessage.separator + walls
        + IMessage.separator
        + spawn + IMessage.separator + powerballs + IMessage.separator + balls + IMessage.separator
        + gate;
  }

}


