package pacManReloaded.common.messages;

import pacManReloaded.common.Command;

public class SingleStringParameterMessage implements IMessage {

  private final String paramValue;
  private Command commandType;

  /**
   * Constructor of the class
   *
   * @param commandType type of the command
   * @param paramValue value of the parameters
   */
  public SingleStringParameterMessage(Command commandType, String paramValue) {
    this.commandType = commandType;
    this.paramValue = paramValue;
  }

  /**
   * "getter" for the value of the parameters
   *
   * @return value of the parameters
   */
  public String getParamValue() {
    return paramValue;
  }

  /**
   * "getter" for the type of the command
   *
   * @return type of the command
   */
  public Command getType() {
    return this.commandType;
  }

  /**
   * the to String method, forms the message into a string, seperated by "|"
   *
   * @return string which contains the command type and the parameter Value seperated by a "|"
   */
  public String toString() {
    return commandType.toString() + IMessage.separator + paramValue;
  }

}
