package pacManReloaded.common.model;

import java.awt.geom.Point2D;
import pacManReloaded.server.Player;

public class Ghost extends Player {

  public GhostColor color;
  private boolean fear;
  private Direction nextDir;


  public Ghost(Point2D.Float point, INavigator nav, Point2D.Float startPoint, Player player) {
    super(player.getClient());
    this.position = point;
    this.navigator = nav;
    this.startPoint = startPoint;
    direction = direction.right;
    speed = 0.2f;
    nextDir = direction.none;
  }

  public Ghost(Point2D.Float point, INavigator nav, Point2D.Float startPoint) {
    super();
    this.position = point;
    this.navigator = nav;
    this.startPoint = startPoint;
    direction = direction.right;
    speed = 0.2f;
    nextDir = direction.none;
  }

  /**
   * ckeck if the next direction is possible, if it is change position, else change position in the
   * same direction
   */
  public void nextMove() {
    checkNextDirection();
    changePosition();
  }

  /**
   * check if the next direction is possible
   */
  private void checkNextDirection() {
    if (nextDir == direction.none) {
      return;
    }
    Object o = null;
    switch (nextDir) {
      case right:
        o = navigator.getObjectAtPosition(new Point2D.Float(position.x + speed, position.y));
        break;
      case left:
        o = navigator.getObjectAtPosition(new Point2D.Float(position.x - speed, position.y));
        break;
      case up:
        o = navigator.getObjectAtPosition(new Point2D.Float(position.x, position.y - speed));
        break;
      case down:
        o = navigator.getObjectAtPosition(new Point2D.Float(position.x, position.y + speed));
        break;
      default:
        break;
    }
    if (!(o instanceof Wall) && !(o instanceof Gate)) {
      direction = nextDir;
      nextDir = direction.none;
    }
  }

  public void changeDir(Direction dir) {
    nextDir = dir;
  }

  public Direction getDirection() {
    return direction;
  }


  private boolean isWholeNumber(float x) {
    double frac = x - ((long) x);
    if (frac * 100 > 1 && frac * 100 < 99) {
      return false;
    } else {
      return true;
    }
  }


  public void setFear(boolean b) {
    fear = b;
  }

}