package pacManReloaded.common.model;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class Map {

  public List<Wall> Walls;
  public List<Wall> Spawn;
  public List<PowerBall> PowerBalls;
  public List<Ball> Balls;
  public Gate gate;
  public int xSize;
  public int ySize;
  public int tSize = 20;

  public Map() throws Exception {
    Walls = new ArrayList<Wall>();
    Spawn = new ArrayList<>();
    PowerBalls = new ArrayList<>();
    Balls = new ArrayList<>();
  }

  /**
   * check position is free of objects
   */
  public boolean isFree(float f, float yStart) {
    if (f < 0 || f > (xSize - 1) || yStart < 0 || yStart > (ySize - 1)) {
      return false;
    }
    List<Point2D.Float> points = new ArrayList<>();
    for (PowerBall powerball : PowerBalls) {
      points.add(powerball.position);
    }
    for (Wall wall : Walls) {
      points.addAll(wall.points);
    }
    for (Wall spawn : Spawn) {
      points.addAll(spawn.points);
    }
    for (Ball ball : Balls) {
      points.add(ball.position);
    }
    points.add(gate.position);
    for (Point2D.Float point : points) {
      if (point.x == f && point.y == yStart) {
        return false;
      }
    }
    return true;
  }

  /**
   * return object that is at the position
   */
  public Object getObject(Point2D.Float actorPos) {
    Point2D.Float displayActorPos = Pos2DisplayPos(actorPos);
    Rectangle2D.Double actor = new Rectangle2D.Double(displayActorPos.getX() + 0.1f,
        displayActorPos.getY() + 0.1f,
        tSize - 0.2f, tSize - 0.2f);
    for (Wall wall : Walls) {
      List<Point2D.Float> points = new ArrayList<>();
      points.addAll(wall.points);
      for (Point2D.Float point : points) {
        Point2D displayPoint = Pos2DisplayPos(point);
        Rectangle2D.Double rect = new Rectangle2D.Double(displayPoint.getX(), displayPoint.getY(),
            tSize,
            tSize);
        if (rect.intersects(actor)) {
          return wall;
        }
      }
    }
    for (Wall wall : Spawn) {
      List<Point2D.Float> points = new ArrayList<>();
      points.addAll(wall.points);
      for (Point2D.Float point : points) {
        Point2D displayPoint = Pos2DisplayPos(point);
        Rectangle2D.Double rect = new Rectangle2D.Double(displayPoint.getX(), displayPoint.getY(),
            tSize,
            tSize);
        if (rect.intersects(actor)) {
          return wall;
        }
      }
    }

    Point2D displayPointGate = Pos2DisplayPos(gate.position);
    Rectangle2D.Double rectGate = new Rectangle2D.Double(displayPointGate.getX(),
        displayPointGate.getY(), tSize,
        tSize);
    if (rectGate.intersects(actor)) {
      return gate;
    }

    for (Ball ball : Balls) {
      Point2D displayPoint = Pos2DisplayPos(ball.position);
      Rectangle2D.Double rect = new Rectangle2D.Double(displayPoint.getX() + 9,
          displayPoint.getY() + 9,
          tSize - 18, tSize - 18);
      if (rect.intersects(actor)) {
        return ball;
      }
    }
    for (PowerBall ball : PowerBalls) {
      Point2D displayPoint = Pos2DisplayPos(ball.position);
      Rectangle2D.Double rect = new Rectangle2D.Double(displayPoint.getX() + 8,
          displayPoint.getY() + 8,
          tSize - 16, tSize - 16);
      if (rect.intersects(actor)) {
        return ball;
      }
    }
    return null;
  }

  public Point2D.Float Pos2DisplayPos(Point2D.Float point) {
    return new Point2D.Float(point.x * tSize, point.y * tSize);
  }

  public float getMapSize() {
    return xSize;
  }

  public void removePowerBall(PowerBall o) {
    PowerBalls.remove(o);
  }

  public void removeBall(Ball o) {
    Balls.remove(o);
  }

}
