package pacManReloaded.common.model;

import java.awt.geom.Point2D;
import pacManReloaded.server.Player;

public class PacMan extends Player {

  private Direction nextDir;


  public PacMan(Point2D.Float point, INavigator nav, Point2D.Float startPoint, Player player) {
    super(player.getClient());
    this.position = point;
    this.navigator = nav;
    this.startPoint = startPoint;
    direction = direction.right;
    speed = 0.2f;
    nextDir = direction.none;
  }

  public PacMan(Point2D.Float point, INavigator nav, Point2D.Float startPoint) {
    super();
    this.position = point;
    this.navigator = nav;
    this.startPoint = startPoint;
    direction = direction.right;
    speed = 0.2f;
    nextDir = direction.none;
  }

  /**
   * check if the next direction is possible
   */
  private void checkNextDirection() {
    if (nextDir == direction.none) {
      return;
    }
    Object o = null;
    switch (nextDir) {
      case right:
        o = navigator.getObjectAtPosition(new Point2D.Float(position.x + speed, position.y));
        break;
      case left:
        o = navigator.getObjectAtPosition(new Point2D.Float(position.x - speed, position.y));
        break;
      case up:
        o = navigator.getObjectAtPosition(new Point2D.Float(position.x, position.y - speed));
        break;
      case down:
        o = navigator.getObjectAtPosition(new Point2D.Float(position.x, position.y + speed));
        break;
      default:
        break;
    }
    if (!(o instanceof Wall) && !(o instanceof Gate)) {
      direction = nextDir;
      nextDir = direction.none;
    }
  }

  /**
   * ckeck if the next direction is possible, if it is change position, else change position in the
   * same direction
   */
  public void nextMove() {
    checkNextDirection();
    changePosition();
  }

  public Direction getDirection() {
    return direction;
  }

  public void changeDir(Direction dir) {
    nextDir = dir;
  }
}
