package pacManReloaded.server;

import pacManReloaded.common.messages.IMessage;

public class HighScore {

  private final String name;
  private int highScore;
  private int number;

  /**
   * Constructor of HighScore
   *
   * @param name name of player who achieved the highscore
   * @param highScore result of the highscore
   */
  public HighScore(String name, int number, int highScore) {
    this.number = number;
    this.highScore = highScore;
    this.name = name;
  }

  /**
   * "getter" for name
   *
   * @return nickname of the player
   */
  public String getName() {
    return name;
  }

  /**
   * "getter" of the result of the highscore
   *
   * @return result of the highscore
   */

  public int getHighScore() {
    return highScore;
  }

  /**
   * "setter" of the result
   *
   * @param highScore result of the highscore
   */
  public void setHighScore(int highScore) {
    this.highScore = highScore;
  }

  public int getNumber() {
    return number;
  }

  /**
   * "setter" of the result
   *
   * @param number result of the number
   */
  public void setNumber(int number) {
    this.number = number;
  }

  @Override
  public String toString() {
    return name + IMessage.separator + number + IMessage.separator + highScore;
  }
}
