package pacManReloaded.server;

import static junit.framework.TestCase.fail;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import pacManReloaded.common.model.Gate;
import pacManReloaded.common.model.Map;
import pacManReloaded.common.model.PowerBall;
import pacManReloaded.common.model.Wall;

public class GameLoaderTest {


  /**
   * tests if a new Gate is created with the right coordinates.
   */
  @Test
  public void createGateTest() {
    GameLoader gameLoader = new GameLoader();
    Gate gate = gameLoader.createGate("16,18");
    Assert.assertEquals(16, gate.position.x, 0);
    Assert.assertEquals(18, gate.position.y, 0);

  }

  /**
   * tests if wall is created with the right coordinates.
   */
  @Test
  public void createWallTest() {
    GameLoader gameLoader = new GameLoader();
    Wall wall = gameLoader.createWall("8,10;");
    Point2D point = wall.points.get(0);
    Assert.assertEquals(8, point.getX(), 0);
    Assert.assertEquals(10, point.getY(), 0);

  }

  /**
   * tests if PowerBall is created with the right coordinates.
   */
  @Test
  public void createPowerBallsTest() {
    GameLoader gameLoader = new GameLoader();
    List<PowerBall> allBalls = gameLoader.createPowerBalls("1,6");
    Assert.assertEquals(1, allBalls.get(0).position.x, 0);
    Assert.assertEquals(6, allBalls.get(0).position.y, 0);

  }

  /**
   * Tests if NullPointerExceptions gets thrown if not enough arguments are given to create a
   * PacMan.
   */
  @Test(expected = NullPointerException.class)
  public void createPacManNullPointerTest() {
      GameLoader gameLoader = new GameLoader();
      gameLoader.createPacMan("2,1");
      fail("Exception not Thrown");

    }

  /**
   * Tests if NullPointerExceptions gets thrown if not enough arguments are given to create a
   * Ghost.
   */
  @Test(expected = NullPointerException.class)
  public void createGhostNullPointerTest() {
      GameLoader gameLoader = new GameLoader();
      gameLoader.createGhost("2,1");
      fail("Exception not Thrown");

  }
}