package pacManReloaded.server;

import static junit.framework.TestCase.fail;

import java.awt.geom.Point2D;
import org.junit.Assert;
import org.junit.Test;
import pacManReloaded.common.model.Ball;
import pacManReloaded.common.model.Ghost;
import pacManReloaded.common.model.INavigator;


public class GameLogicTest {

  /**
   * testing the isDone Method by looking if it is returning the right Boolean. Here the expected is
   * true.
   */
  @Test
  public void isDoneTrueTest() {
    GameLogic gameLogic = new GameLogic();
    gameLogic.gameState.gameStatus = GameStatus.done;
    Assert.assertEquals(true, gameLogic.isDone());
  }

  /**
   * testing the isDone Method by looking if it is returning the right Boolean. Here the expected is
   * false.
   */
  @Test
  public void isDoneFalseTest() {
    GameLogic gameLogic = new GameLogic();
    gameLogic.gameState.gameStatus = GameStatus.playing;
    Assert.assertEquals(false, gameLogic.isDone());
  }

  /**
   * Testing if getGameStatus() returns the correct GameStatus.
   */
  @Test
  public void getGameStatusTest() {
    GameLogic gameLogic = new GameLogic();
    gameLogic.gameState.gameStatus = GameStatus.playing;
    Assert.assertEquals(GameStatus.playing, gameLogic.getGameStatus());

  }

  /**
   * Testing if setGameStatus() returns the GameStatus correctly.
   */
  @Test
  public void setGameStatusTest() {
    GameLogic gameLogic = new GameLogic();
    gameLogic.setGameStatus(GameStatus.playing);
    Assert.assertEquals(GameStatus.playing, gameLogic.gameState.gameStatus);
  }

  /**
   * Testing if getMapSize() returns the Map size correctly by creating a dummy-Map.
   */
  @Test
  public void getMapSizeTest() {
    GameLogic gameLogic = new GameLogic();
    gameLogic.map.xSize = 20;
    Assert.assertEquals(20, gameLogic.getMapSize(), 0.0000002);
  }

  /**
   * Testing if getGameState() returns the Game State correctly.
   */
  @Test
  public void getGameState() {
    GameLogic gameLogic = new GameLogic();
    gameLogic.gameState.gameStatus = GameStatus.playing;
    GameState gs = gameLogic.getGameState();
    Assert.assertEquals(GameStatus.playing, gs.gameStatus);
  }

  /**
   * Testing if ScoreGhoast is stored correctly in the gameState
   */
  @Test
  public void getGameStateScoreGhoastTest() {
    GameLogic gameLogic = new GameLogic();
    gameLogic.gameState.scoreGhost = 15;
    GameState gs = gameLogic.getGameState();
    Assert.assertEquals(15, gs.scoreGhost);
  }

  /**
   * Testing if ScoreGhoast is stored correctly in the gameState
   */
  @Test
  public void getGameStateScorePacManTest() {
    GameLogic gameLogic = new GameLogic();
    gameLogic.gameState.scorePacMan = 17;
    GameState gs = gameLogic.getGameState();
    Assert.assertEquals(17, gs.scorePacMan);

  }

  /**
   * Testing if the state of the SuperPower is stored correctly on the game state.
   */
  @Test
  public void getGameStateSuperPowerTest() {
    GameLogic gameLogic = new GameLogic();
    gameLogic.gameState.superPower = 1;
    GameState gs = gameLogic.getGameState();
    Assert.assertEquals(1, gs.superPower);
  }

  /**
   * Testing if Balls are created in the right coordinates.
   */
  @Test
  public void createBallTest() {
    GameLogic gameLogic = new GameLogic();
    Point2D.Float point = new Point2D.Float(7, 8);
    gameLogic.createBall(point);
    Ball ball = gameLogic.map.Balls.get(0);
    Assert.assertEquals(7, ball.position.x, 0);
    Assert.assertEquals(8, ball.position.y, 0);


  }

  /**
   * Testing if NullPointerException occurs if getPacman() is called without the proper
   * background-structure.
   */
  @Test(expected = NullPointerException.class)
  public void nextMoveTest() {
      GameLogic gameLogic = new GameLogic();
      gameLogic.nextMove();
      fail("Exception not Thrown");

  }

  /**
   * Testing if NullPointerException occurs if getPacman() is called without the proper
   * background-structure.
   */
  @Test(expected = NullPointerException.class)
  public void detectCollisionsTest() {
      GameLogic gameLogic = new GameLogic();
      gameLogic.detectCollisions();
      fail("Exception not Thrown");

    }

  /**
   * Testing if NullPointerException occurs if getPacman() is called without the proper
   * background-structure.
   */
  @Test(expected = NullPointerException.class)
  public void getPacManTest() {
      GameLogic gameLogic = new GameLogic();
      gameLogic.getPacman();
      fail("Exception not Thrown");

  }

  /**
   * Testing if NullPointerException occurs if collisionWithBallPacMan is called without the proper
   * background-structure.
   */
  @Test(expected = NullPointerException.class)
  public void collisionWithBallPacManTest() {
      GameLogic gameLogic = new GameLogic();
      Point2D.Float point = new Point2D.Float(7, 8);
      gameLogic.createBall(point);
      Ball o = new Ball(point);
      gameLogic.collisionWithBallPacMan(o);
      fail("Exception not Thrown");

  }

  /**
   * Testing if NullPointerException occurs if collisionWithBallGhost() is called without the proper
   * background-structure.
   */
  @Test(expected = NullPointerException.class)
  public void collisionWithBallGhostTest() {
      GameLogic gameLogic = new GameLogic();
      Point2D.Float point = new Point2D.Float(7, 8);
      gameLogic.createBall(point);
      Ball o = new Ball(point);
      gameLogic.collisionWithBallGhost(o);
      fail("Exception not Thrown");

    }

  /**
   * Testing if NullPointerException occurs if collisionWithPowerballPacman() is called without the
   * proper background-structure.
   */
  @Test(expected = NullPointerException.class)
  public void collisionWithPowerballPacManTest() {
      GameLogic gameLogic = new GameLogic();
      Point2D.Float point = new Point2D.Float(7, 8);
      gameLogic.createBall(point);
      Ball o = new Ball(point);
      gameLogic.collisionWithBallPacMan(o);
      fail("Exception not Thrown");

  }

  /**
   * Testing if NullPointerException occurs if collisionWithPowerballGhost() is called without the
   * proper background-structure.
   */
  @Test(expected = NullPointerException.class)
  public void collisionWithPowerballGhostTest() {
      GameLogic gameLogic = new GameLogic();
      Point2D.Float point = new Point2D.Float(7, 8);
      gameLogic.createBall(point);
      Ball o = new Ball(point);
      gameLogic.collisionWithBallGhost(o);
      fail("Exception not Thrown");

  }

  /**
   * Testing if NullPointerException occurs if removeObjectTest() is called without the proper
   * background-structure.
   */
  @Test(expected = NullPointerException.class)
  public void removeObjectTest() {
      GameLogic gameLogic = new GameLogic();
      Point2D.Float point = new Point2D.Float(7, 8);
      gameLogic.createBall(point);
      Ball o = new Ball(point);
      gameLogic.removeObject(o);
      fail("Exception not Thrown");
    }

  /**
   * Testing if NullPointerException occurs if checkSuperPowerTest() is called without the proper
   * background-structure.
   */
  @Test(expected = NullPointerException.class)
  public void checkSuperPowerTest() {
      GameLogic gameLogic = new GameLogic();
      gameLogic.checkSuperPower();
      fail("Exception not Thrown");

  }

  /**
   * Testing if NullPointerException occurs if isInSpawn() is called without the proper
   * background-structure.
   */
  @Test(expected = NullPointerException.class)
  public void isInSpawnTest() {
      GameLogic gameLogic = new GameLogic();
      Point2D.Float point = new Point2D.Float(7, 8);
      INavigator nav = null;
      Player p = null;
      Ghost ghost = new Ghost(point, nav, point, p);
      gameLogic.isInSpawn(ghost);
      fail("Exception not Thrown");


  }
}